% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{bs4Ribbon}
\alias{bs4Ribbon}
\title{Create a Boostrap 4 ribbon}
\usage{
bs4Ribbon(
  text,
  status = c("primary", "danger", "success", "warning", "info", "secondary"),
  size = NULL
)
}
\arguments{
\item{text}{Ribbon text.}

\item{status}{Ribbon status: "primary", "danger", "success", "warning", "info" and 
"secondary".}

\item{size}{NULL by default: "lg" or "xl".}
}
\description{
Build a bootstrap 4 ribbon
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)
 shinyApp(
  ui = bs4DashPage(
    navbar = bs4DashNavbar(), 
    sidebar = bs4DashSidebar(),
    body = bs4DashBody(
     fluidRow(
      bs4Box(
       width = 4,
       title = "Normal ribbon",
       bs4Ribbon(
        text = "New",
        status = "primary"
       )
      ),
      bs4Box(
       width = 4,
       title = "Large ribbon",
       bs4Ribbon(
        text = "New",
        status = "secondary",
        size = "lg"
       )
      ),
      bs4Box(
       width = 4,
       title = "XLarge ribbon",
       bs4Ribbon(
        text = "New",
        status = "danger",
        size = "xl"
       )
      )
     )
    ), 
    footer = bs4DashFooter()
  ),
  server = function(input, output) { }
 )
}


}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
