% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cards.R
\name{updatebs4Card}
\alias{updatebs4Card}
\title{update an AdminLTE3 card from the server side}
\usage{
updatebs4Card(
  inputId,
  session,
  action = c("remove", "toggle", "toggleMaximize", "restore")
)
}
\arguments{
\item{inputId}{Card inputId}

\item{session}{Shiny session}

\item{action}{Action to trigger: \code{c("remove", "toggle", "toggleMaximize", "restore")}.}
}
\description{
update an AdminLTE3 card from the server side
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)
 
 shiny::shinyApp(
   ui = dashboardPage(
     sidebar_collapsed = TRUE,
     navbar = dashboardHeader(),
     sidebar = dashboardSidebar(),
     body = dashboardBody(
       actionButton(inputId = "triggerCard", label = "Trigger Card Action"),
       selectInput(
         inputId = "cardAction", 
         label = "Card action", 
         choices = c(
           "remove",
           "toggle",
           "toggleMaximize",
           "restore"
         )
       ),
       
       bs4Card(
         inputId = "mycard",
         title = "The plot is visible when you maximize the card", 
         closable = TRUE, 
         maximizable = TRUE,
         width = 12,
         status = "warning", 
         solidHeader = FALSE, 
         collapsible = TRUE,
         sliderInput("obs", "Number of observations:",
                     min = 0, max = 1000, value = 500
         ),
         plotOutput("distPlot")
       )
     )
   ),
   server = function(input, output, session) {
     
     output$distPlot <- renderPlot({
       if (input$mycard$maximized) {
         hist(rnorm(input$obs)) 
       }
     })
     
     observeEvent(input$triggerCard, {
       updatebs4Card(inputId = "mycard", session = session, action = input$cardAction)
     })
     
     observe({
       print(
         list(
           collapsed = input$mycard$collapsed,
           maximized = input$mycard$maximized,
           visible = input$mycard$visible
         )
       )
     })
   }
 )
}
}
