% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{conv}
\alias{conv}
\title{Test a model for convergence}
\usage{
conv(model)
}
\arguments{
\item{model}{The model object to test.}
}
\value{
Logical indicating whether the model converged.
}
\description{
Test a model for convergence
}
\examples{
library(buildmer)
library(lme4)
good1 <- lm(Reaction ~ Days,sleepstudy)
good2 <- lmer(Reaction ~ Days + (Days|Subject),sleepstudy)
bad <- lmer(Reaction ~ Days + (Days|Subject),sleepstudy,control=lmerControl(
            optimizer='bobyqa',optCtrl=list(maxfun=1)))
sapply(c(good1,good2,bad),conv)
}
