% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/childesr.R
\name{get_speaker_statistics}
\alias{get_speaker_statistics}
\title{Get speaker statistics}
\usage{
get_speaker_statistics(collection = NULL, corpus = NULL,
  target_child = NULL, role = NULL, role_exclude = NULL,
  age = NULL, sex = NULL, connection = NULL,
  db_version = "current", db_args = NULL)
}
\arguments{
\item{collection}{A character vector of one or more names of collections}

\item{corpus}{A character vector of one or more names of corpora}

\item{target_child}{A character vector of one or more names of children}

\item{role}{A character vector of one or more roles to include}

\item{role_exclude}{A character vector of one or more roles to exclude}

\item{age}{A numeric vector of an age or a min age (inclusive) and max age
(exclusive) in months}

\item{sex}{A character vector of values "male" and/or "female"}

\item{connection}{A connection to the CHILDES database}

\item{db_version}{String of the name of database version to use}

\item{db_args}{List with host, user, and password defined}
}
\value{
A `tbl` of Speaker statistics, filtered down by supplied arguments.
  If `connection` is supplied, the result remains a remote query, otherwise
  it is retrieved into a local tibble.
}
\description{
Get speaker statistics
}
\examples{
\donttest{
get_speaker_statistics()
}
}
