% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.R
\name{ds}
\alias{ds}
\title{Get David's Scores of Individuals}
\usage{
ds(m, norm = FALSE, type = "D")
}
\arguments{
\item{m}{A matrix with individuals ordered identically in rows and columns.}

\item{norm}{whether to normalize scores}

\item{type}{either \code{method="D"} for Dij or \code{method="P"} for Pij.}
}
\value{
a vector of David scores in same order as names of \code{m}.
}
\description{
Get David's Scores of Individuals
}
\section{References}{

Gammell et al, 2003, David's score: a more appropriate dominance ranking method
than Clutton-Brock et al.'s index, Animal Behaviour.
}
\examples{
m <- matrix(c(NA,2,30,6,19,122,0,NA,18,
0,19,85,0,1,NA,3,8,84,0,0,0,NA,267,50,0,
0,0,5,NA,10,1,0,4,4,1,NA), ncol=6)  #table 2, Vervaecke et al. 2000  - fleeing in bonobos
ds(m)
ds(m,type="P")
ds(m,norm=TRUE)
}

