% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constellate.R
\name{constellate}
\alias{constellate}
\title{Identify when a constellation of events occur}
\usage{
constellate(..., window_hours, join_key, time_var, event_name, mult = c("all",
  "first", "last"))
}
\arguments{
\item{...}{An arbitrary number of time series data frames that each include
the columns 'join_key' and 'time_var'}

\item{window_hours}{A single numeric or vector of numerics specifying the
number of hours to search for each event. The order of numerics in the
vector should align with the order of data frames passed in '...'.}

\item{join_key}{A string name of the column to join all time series data
frames}

\item{time_var}{A string name of the time stamp column in all time series
data frames}

\item{event_name}{A string name for events across the time series data
frames}

\item{mult}{A string specifying whether to return the first, last, or all
instance(s) with a default value of all}
}
\value{
A data.frame, data.table with time stamps of qualifying events.
}
\description{
A function that reads in multiple time series data frames and calculates
 instances when a constellation of events occur.
The user must specify the number of hours over which each event must take
 place, a variable to use to join the tables, and the time stamp variable.
 In addition, the user must specify the event name and whether to keep all
 instances that events occur, or only the first or last instance. This
 function can ingest an arbitrary number of data frames with longitudinal
 time series data.
}
\section{Imported functions}{

fastPOSIXct() from fasttime package and data.table syntax
}

\section{Errors}{

This function returns errors for:
\itemize{
 \item missing arguments (no arguments have defaults)
 \item passing an invalid mult value
 \item passing arguments with invalid classes (window_hours must be numeric
   and event_name must be a string)
 \item passing join_key or time_var values that are not column names in all
   time series data frames
 \item passing an invalid number of window_hours values (1 or the number of
 event data frames).
}
}

\examples{
library(data.table)
temp <- as.data.table(vitals[VARIABLE == "TEMPERATURE"])
pulse <- as.data.table(vitals[VARIABLE == "PULSE"])
resp <- as.data.table(vitals[VARIABLE == "RESPIRATORY_RATE"])
wbc <- as.data.table(labs[VARIABLE == "WBC"])

# Pass single time window for all time series data frames
# Subset first event
constellate(temp, pulse, resp, window_hours = 6, join_key = "PAT_ID",
 time_var = "RECORDED_TIME", event_name = "sirs_vitals", mult = "first")
# Pass different time window for each time series data frame
# Subset first event
constellate(temp, pulse, resp, wbc, window_hours = c(6,6,6,24),
 join_key = "PAT_ID", time_var = "RECORDED_TIME",
 event_name = "SEPSIS", mult = "first")
# Pass different time window for each time series data frame
# Identify all events
constellate(temp, pulse, resp, wbc, window_hours = c(6,6,6,24),
 join_key = "PAT_ID", time_var = "RECORDED_TIME",
 event_name = "SEPSIS", mult = "all")

}
