% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_controller_sequential.R
\name{crew_class_controller_sequential}
\alias{crew_class_controller_sequential}
\title{Sequential controller class}
\description{
\code{R6} class for sequential controllers.
}
\details{
See \code{\link[=crew_controller_sequential]{crew_controller_sequential()}}.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
controller <- crew_controller_sequential()
controller$push(name = "task", command = sqrt(4))
controller$pop()
}
}
\seealso{
Other sequential controllers: 
\code{\link{crew_controller_sequential}()}
}
\concept{sequential controllers}
\section{Super class}{
\code{\link[crew:crew_class_controller]{crew::crew_class_controller}} -> \code{crew_class_controller_sequential}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_controller_sequential-start}{\code{crew_class_controller_sequential$start()}}
\item \href{#method-crew_class_controller_sequential-launch}{\code{crew_class_controller_sequential$launch()}}
\item \href{#method-crew_class_controller_sequential-scale}{\code{crew_class_controller_sequential$scale()}}
\item \href{#method-crew_class_controller_sequential-autoscale}{\code{crew_class_controller_sequential$autoscale()}}
\item \href{#method-crew_class_controller_sequential-descale}{\code{crew_class_controller_sequential$descale()}}
\item \href{#method-crew_class_controller_sequential-push}{\code{crew_class_controller_sequential$push()}}
\item \href{#method-crew_class_controller_sequential-wait}{\code{crew_class_controller_sequential$wait()}}
\item \href{#method-crew_class_controller_sequential-push_backlog}{\code{crew_class_controller_sequential$push_backlog()}}
\item \href{#method-crew_class_controller_sequential-pop_backlog}{\code{crew_class_controller_sequential$pop_backlog()}}
\item \href{#method-crew_class_controller_sequential-cancel}{\code{crew_class_controller_sequential$cancel()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_controller" data-id="collect"><a href='../../crew/html/crew_class_controller.html#method-crew_class_controller-collect'><code>crew::crew_class_controller$collect()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_controller" data-id="crashes"><a href='../../crew/html/crew_class_controller.html#method-crew_class_controller-crashes'><code>crew::crew_class_controller$crashes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_controller" data-id="empty"><a href='../../crew/html/crew_class_controller.html#method-crew_class_controller-empty'><code>crew::crew_class_controller$empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_controller" data-id="initialize"><a href='../../crew/html/crew_class_controller.html#method-crew_class_controller-initialize'><code>crew::crew_class_controller$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_controller" data-id="map"><a href='../../crew/html/crew_class_controller.html#method-crew_class_controller-map'><code>crew::crew_class_controller$map()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_controller" data-id="nonempty"><a href='../../crew/html/crew_class_controller.html#method-crew_class_controller-nonempty'><code>crew::crew_class_controller$nonempty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_controller" data-id="pids"><a href='../../crew/html/crew_class_controller.html#method-crew_class_controller-pids'><code>crew::crew_class_controller$pids()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_controller" data-id="pop"><a href='../../crew/html/crew_class_controller.html#method-crew_class_controller-pop'><code>crew::crew_class_controller$pop()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_controller" data-id="promise"><a href='../../crew/html/crew_class_controller.html#method-crew_class_controller-promise'><code>crew::crew_class_controller$promise()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_controller" data-id="resolved"><a href='../../crew/html/crew_class_controller.html#method-crew_class_controller-resolved'><code>crew::crew_class_controller$resolved()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_controller" data-id="saturated"><a href='../../crew/html/crew_class_controller.html#method-crew_class_controller-saturated'><code>crew::crew_class_controller$saturated()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_controller" data-id="started"><a href='../../crew/html/crew_class_controller.html#method-crew_class_controller-started'><code>crew::crew_class_controller$started()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_controller" data-id="summary"><a href='../../crew/html/crew_class_controller.html#method-crew_class_controller-summary'><code>crew::crew_class_controller$summary()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_controller" data-id="terminate"><a href='../../crew/html/crew_class_controller.html#method-crew_class_controller-terminate'><code>crew::crew_class_controller$terminate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_controller" data-id="unpopped"><a href='../../crew/html/crew_class_controller.html#method-crew_class_controller-unpopped'><code>crew::crew_class_controller$unpopped()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_controller" data-id="unresolved"><a href='../../crew/html/crew_class_controller.html#method-crew_class_controller-unresolved'><code>crew::crew_class_controller$unresolved()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_controller" data-id="validate"><a href='../../crew/html/crew_class_controller.html#method-crew_class_controller-validate'><code>crew::crew_class_controller$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_controller" data-id="walk"><a href='../../crew/html/crew_class_controller.html#method-crew_class_controller-walk'><code>crew::crew_class_controller$walk()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_sequential-start"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_sequential-start}{}}}
\subsection{Method \code{start()}}{
Start the controller if it is not already started.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_sequential$start(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
For the sequential controller, there is nothing to do
except register the client as started.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_sequential-launch"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_sequential-launch}{}}}
\subsection{Method \code{launch()}}{
Does nothing for the sequential controller.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_sequential$launch(n = 1L, controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of workers to launch.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_sequential-scale"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_sequential-scale}{}}}
\subsection{Method \code{scale()}}{
Does nothing for the sequential controller.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_sequential$scale(throttle = TRUE, controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{throttle}}{Not applicable to the sequential controller.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisibly returns \code{FALSE}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_sequential-autoscale"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_sequential-autoscale}{}}}
\subsection{Method \code{autoscale()}}{
Not applicable to the sequential controller.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_sequential$autoscale(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_sequential-descale"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_sequential-descale}{}}}
\subsection{Method \code{descale()}}{
Not applicable to the sequential controller.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_sequential$descale(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_sequential-push"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_sequential-push}{}}}
\subsection{Method \code{push()}}{
Push a task to the head of the task list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_sequential$push(
  command,
  data = list(),
  globals = list(),
  substitute = TRUE,
  seed = NULL,
  algorithm = NULL,
  packages = character(0),
  library = NULL,
  seconds_timeout = NULL,
  scale = TRUE,
  throttle = TRUE,
  name = NULL,
  save_command = NULL,
  controller = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{command}}{Language object with R code to run.}

\item{\code{data}}{Named list of local data objects in the
evaluation environment.}

\item{\code{globals}}{Named list of objects to temporarily assign to the
global environment for the task.
This list should
include any functions you previously defined in the global
environment which are required to run tasks.
See the \code{reset_globals} argument
of \code{\link[=crew_controller_local]{crew_controller_local()}}.}

\item{\code{substitute}}{Logical of length 1, whether to call
\code{base::substitute()} on the supplied value of the
\code{command} argument. If \code{TRUE} (default) then \code{command} is quoted
literally as you write it, e.g.
\code{push(command = your_function_call())}. If \code{FALSE}, then \code{crew}
assumes \code{command} is a language object and you are passing its
value, e.g. \code{push(command = quote(your_function_call()))}.
\code{substitute = TRUE} is appropriate for interactive use,
whereas \code{substitute = FALSE} is meant for automated R programs
that invoke \code{crew} controllers.}

\item{\code{seed}}{Integer of length 1 with the pseudo-random number generator
seed to set for the evaluation of the task. Passed to the
\code{seed} argument of \code{set.seed()} if not \code{NULL}.
If \code{algorithm} and \code{seed} are both \code{NULL} for the sequential
controller, then the random number generator defaults to the
current RNG of the local R session where the sequential
controller lives.}

\item{\code{algorithm}}{Integer of length 1 with the pseudo-random number
generator algorithm to set for the evaluation of the task.
Passed to the \code{kind} argument of \code{RNGkind()} if not \code{NULL}.
If \code{algorithm} and \code{seed} are both \code{NULL} for the sequential
controller, then the random number generator defaults to the
current RNG of the local R session where the sequential
controller lives.}

\item{\code{packages}}{Character vector of packages to load for the task.}

\item{\code{library}}{Library path to load the packages. See the \code{lib.loc}
argument of \code{require()}.}

\item{\code{seconds_timeout}}{Not used in the sequential controller..}

\item{\code{scale}}{Not used in the sequential controller.}

\item{\code{throttle}}{Not used in the sequential controller.}

\item{\code{name}}{Character string, name of the task. If \code{NULL}, then
a random name is generated automatically.
The name of the task must not conflict with the name of another
task pushed to the controller. Any previous task with the same name
must first be popped before a new task with that name can be pushed.}

\item{\code{save_command}}{Deprecated on 2025-01-22 (\code{crew} version
0.10.2.9004) and no longer used.}

\item{\code{controller}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Invisibly returns a \code{mirai}-like list where the \code{data}
element is the result of the task.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_sequential-wait"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_sequential-wait}{}}}
\subsection{Method \code{wait()}}{
Not applicable to the sequential controller.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_sequential$wait(
  mode = "all",
  seconds_interval = NULL,
  seconds_timeout = Inf,
  scale = TRUE,
  throttle = TRUE,
  controllers = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mode}}{Not applicable to the sequential controller.}

\item{\code{seconds_interval}}{Not applicable to the sequential controller.}

\item{\code{seconds_timeout}}{Not applicable to the sequential controller.}

\item{\code{scale}}{Not applicable to the sequential controller.}

\item{\code{throttle}}{Not applicable to the sequential controller.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Always returns \code{TRUE} (invisibly)
for the sequential controller.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_sequential-push_backlog"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_sequential-push_backlog}{}}}
\subsection{Method \code{push_backlog()}}{
Not applicable to the sequential controller.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_sequential$push_backlog(name, controller = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Character of length 1 with the task name to push to
the backlog.}

\item{\code{controller}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_sequential-pop_backlog"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_sequential-pop_backlog}{}}}
\subsection{Method \code{pop_backlog()}}{
Not applicable to the sequential controller.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_sequential$pop_backlog(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Always \code{character(0L)} for the sequential controller.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller_sequential-cancel"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller_sequential-cancel}{}}}
\subsection{Method \code{cancel()}}{
Not applicable to the sequential controller.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller_sequential$cancel(names = character(0L), all = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{names}}{Not applicable to the sequential controller.}

\item{\code{all}}{Not applicable to the sequential controller.}
}
\if{html}{\out{</div>}}
}
}
}
