% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOptLambda.R
\name{getOptLambda}
\alias{getOptLambda}
\title{Get lambda.min and lambda.1se values}
\usage{
getOptLambda(lambda, cvm, cvsd, type.measure)
}
\arguments{
\item{lambda}{The values of lambda used in the fits.}

\item{cvm}{The mean cross-validated error: a vector of length
`length(lambda)`.}

\item{cvsd}{Estimate of standard error of `cvm`.}

\item{type.measure}{Loss function used for CV.}
}
\value{
A list with the following elements:
\item{lambda.min}{Value of `lambda` that gives minimum `cvm`.}
\item{lambda.1se}{Largest value of `lambda` such that the error is within
1 standard error of the minimum.}
\item{index}{A one-column matrix with the indices of `lambda.min` and
`lambda.1se` in the sequence of coefficients, fits etc.}
}
\description{
Get lambda.min and lambda.1se values and indices.
}
