% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize_entity.R
\name{match_entities_with_patterns}
\alias{match_entities_with_patterns}
\title{Match entities with patterns using fuzzyjoin}
\usage{
match_entities_with_patterns(
  data,
  target_cols,
  patterns,
  warn_ambiguous = TRUE
)
}
\arguments{
\item{data}{A data frame containing the columns to match}

\item{target_cols}{Character vector of column names to match}

\item{patterns}{Data frame containing entity patterns; if NULL, uses
list_entity_patterns()}

\item{warn_ambiguous}{Logical; whether to warn about ambiguous matches}
}
\value{
A data frame with the unique combinations of the target columns
mapped to the entity patterns
}
\description{
Given a data frame and a vector of target columns, perform regex matching
on the target columns until all entities are matched or we run out of
columns to match. Warn about ambiguous matches (duplicate entity_id values).
Return a data frame mapping the target columns to the entity patterns.
}
\keyword{internal}
