% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{standardizeArgument_editable}
\alias{standardizeArgument_editable}
\title{Standardized editable argument to be in the form of a list}
\usage{
standardizeArgument_editable(editable, data)
}
\arguments{
\item{editable}{\code{FALSE} to disable the table editor, or \code{TRUE} (or
\code{"cell"}) to enable editing a single cell. Alternatively, you can set
it to \code{"row"} to be able to edit a row, or \code{"column"} to edit a
column, or \code{"all"} to edit all cells on the current page of the table.
In all modes, start editing by doubleclicking on a cell. This argument can
also be a list of the form \code{list(target = TARGET, disable =
list(columns = INDICES))}, where \code{TARGET} can be \code{"cell"},
\code{"row"}, \code{"column"}, or \code{"all"}, and \code{INDICES} is an
integer vector of column indices. Use the list form if you want to disable
editing certain columns. You can also restrict the editing to accept only
numbers by setting this argument to a list of the form \code{list(target =
TARGET, numeric = INDICES)} where \code{INDICES} can be the vector of the
indices of the columns for which you want to restrict the editing to
numbers or \code{"all"} to restrict the editing to numbers for all columns.
If you don't set \code{numeric}, then the editing is restricted to numbers
for all numeric columns; set \code{numeric = "none"} to disable this
behavior. It is also possible to edit the cells in text areas, which are
useful for large contents. For that, set the \code{editable} argument to a
list of the form \code{list(target = TARGET, area = INDICES)} where
\code{INDICES} can be the vector of the indices of the columns for which
you want the text areas, or \code{"all"} if you want the text areas for
all columns. Of course, you can request the numeric editing for some
columns and the text areas for some other columns by setting
\code{editable} to a list of the form \code{list(target = TARGET, numeric
= INDICES1, area = INDICES2)}. Finally, you can edit date cells with a
calendar with \code{list(target = TARGET, date = INDICES)}; the target
columns must have the \code{Date} type. If you don't set \code{date} in
the \code{editable} list, the editing with the calendar is automatically
set for all \code{Date} columns.}

\item{data}{\code{tbl}. The function will automatically cast to tbl if needed.}
}
\value{
list of the form \code{list(target = foo, ...)}
}
\description{
Standardized editable argument to be in the form of a list
}
\author{
Jasper Schelfhout
}
