% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyInput.R
\name{inputUI}
\alias{inputUI}
\title{An input UI for a \code{data.frame}}
\usage{
inputUI(id, ...)
}
\arguments{
\item{id}{\code{character(1)} module id}

\item{...}{arguments passed onto methods}
}
\value{
HTML. A set of input fields corresponding to the given row.
}
\description{
An input UI for a \code{data.frame}
}
\details{
A new method for this can be added if you wish to alter the default behavior of the pop-up modals in \code{\link{eDT}}.
}
\examples{
if(interactive()){
  library(shiny)
  ui <- inputUI('id')
  server <- function(input,output,session){
    input <- inputServer("id", mtcars[1,])
    observe({print(input())})
  }
shinyApp(ui, server)
}

}
\author{
Jasper Schelfhout
}
