% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrf_create.R
\name{wrf_create}
\alias{wrf_create}
\title{Create emission files for the WRF-Chem model}
\usage{
wrf_create(
  wrfinput_dir = getwd(),
  wrfchemi_dir = wrfinput_dir,
  domains = 1,
  frames_per_auxinput5 = 1,
  auxinput5_interval_m = 60,
  day_offset = 0,
  io_style_emissions = 2,
  kemit = 1,
  variables = "ecbmz_mosaic",
  n_aero = 14,
  COMPRESS = NA,
  force_ncdf4 = FALSE,
  title = "Anthropogenic emissions for WRF V4.0",
  separator = "default",
  verbose = FALSE
)
}
\arguments{
\item{wrfinput_dir}{input folder with the wrfinput file(s)}

\item{wrfchemi_dir}{output folder}

\item{domains}{domain / domains to be process}

\item{frames_per_auxinput5}{value from wrf &time_control namelist.input,
number of times (frames) in a single emission file}

\item{auxinput5_interval_m}{value from wrf &time_control namelist.input,
interval in minutes between different times (frames) see Details}

\item{day_offset}{number of days (can be a fraction) see Details}

\item{io_style_emissions}{from wrf &chem namelist.input see Details}

\item{kemit}{from wrf &chem namelist.input, number of vertical levels of the emission file}

\item{variables}{emission species, can be used \code{emis_opt}}

\item{n_aero}{number of aerosol species}

\item{COMPRESS}{integer between 1 (least compr) and 9 (most compr) or NA for
no compression}

\item{force_ncdf4}{force NetCDF4 format}

\item{title}{TITLE attribute for the NetCDF}

\item{separator}{filename alternative separator when io_style_emission=1}

\item{verbose}{print file info}
}
\description{
Create WRF-chem emission files using information from the WRF initial condictions (wrfinput) file(s). The wrfinput file of the corresponding domain is read from the current folder or from the wrfinput_dir.

There are two emission styles available: the 12 hour pair of emissions (that will be recycled by the model) using io_style_emissions = 1 and the date_hour format using io_style_emissions = 2 (default), see notes for more detail.

The initial time is the original (wrfinput file) adjusted by the day_offset argument, this argument can be useful for split the emissions into several files or for a restarted simulation. The emissions are recorded at the interval of 60 minutes (or the auxinput5_interval_m argument) for 1 time (or frames_per_auxinput5 argument times).

The variables created on output file is based on emis_opt data or a character vector contains the species, any change in variables need to be followed by a change in the n_aero for the correspondent number of aerosol species in the emission file (the n_aero last variables).

Title argument will be written on global attribute TITLE, from the version 4.0 the model checks if the TITLE version contains "V4.", this can be disabled setting 'force_use_old_data = .true.' on WRF namelist.input.
}
\note{
Using io_style_emissions = 1, the wrfchemi_00z will be generated with day_offset = 0 and
wrfchemi_12z with day_offset = 0.5 (frames_per_auxinput5 and auxinput5_interval_m will have no effect).

Windows users may need to rename the emission files or change in namelist the defoult filename before run wrf.exe with these emission files.

The separator argument can be useful for write in NTSF format discs on linux systems, for 'default' the separator is ':' for linux-like systems and '\%3A' for windowns.
}
\examples{
\dontrun{
# Do not run

# emissions for a 1 day forecast for domains 1 and 2

dir.create(file.path(tempdir(), "EMISS"))

# emissions on date_hour style
wrf_create(wrfinput_dir         = system.file("extdata", package = "eixport"),
           wrfchemi_dir         = file.path(tempdir(), "EMISS"),
           domains              = 1:2,
           frames_per_auxinput5 = 25,
           auxinput5_interval_m = 60,
           verbose              = TRUE)

# emissions on 00z / 12z style, create the 00z
wrf_create(wrfinput_dir         = system.file("extdata", package = "eixport"),
           wrfchemi_dir         = file.path(tempdir(), "EMISS"),
           domains              = 1:2,
           io_style_emissions   = 1,
           day_offset           = 0,
           verbose              = TRUE,
           )
# emissions on 00z / 12z style, create the 12z
wrf_create(wrfinput_dir         = system.file("extdata", package = "eixport"),
           wrfchemi_dir         = file.path(tempdir(), "EMISS"),
           domains              = 1:2,
           io_style_emissions   = 1,
           day_offset           = 0.5,
           verbose              = TRUE)
}
}
\seealso{
\code{\link{to_wrf}} and \code{\link{emis_opt}}
}
\author{
Daniel Schuch
}
