% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hfit.R
\docType{methods}
\name{hfit}
\alias{hfit}
\alias{hfit,hspec-method}
\title{Perform maximum likelihood estimation}
\usage{
hfit(
  object,
  inter_arrival = NULL,
  type = NULL,
  mark = NULL,
  N = NULL,
  Nc = NULL,
  lambda_component0 = NULL,
  N0 = NULL,
  mylogLik = NULL,
  reduced = TRUE,
  grad = NULL,
  hess = NULL,
  constraint = NULL,
  method = "BFGS",
  verbose = FALSE,
  ...
)

\S4method{hfit}{hspec}(
  object,
  inter_arrival = NULL,
  type = NULL,
  mark = NULL,
  N = NULL,
  Nc = NULL,
  lambda_component0 = NULL,
  N0 = NULL,
  mylogLik = NULL,
  reduced = TRUE,
  grad = NULL,
  hess = NULL,
  constraint = NULL,
  method = "BFGS",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{\code{\link{hspec-class}}. This object includes the parameter values}

\item{inter_arrival}{Inter-arrival times of events which includes inter-arrival for events that occur in all dimensions. Start with zero.}

\item{type}{A vector of dimensions. Distinguished by numbers, 1, 2, 3, and so on. Start with zero.}

\item{mark}{A vector of mark (jump) sizes. Start with zero.}

\item{N}{A matrix of counting processes.}

\item{Nc}{A matrix of counting processes weighted by mark.}

\item{lambda_component0}{Initial values of lambda component. It must have the same dimensional matrix (n by n) with \code{object}.}

\item{N0}{Initial values of N.}

\item{mylogLik}{User defined log-likelihood function. \code{mylogLik} function should have \code{object} argument consistent with \code{object}.}

\item{reduced}{When \code{TRUE}, reduced estimation performed.}

\item{grad}{A Gradient matrix for the likelihood function. For more information, see \code{\link[maxLik]{maxLik}}.}

\item{hess}{A Hessian matrix for the likelihood function. For more information, see \code{\link[maxLik]{maxLik}}.}

\item{constraint}{Constraint matrices. For more information, see \code{\link[maxLik]{maxLik}}.}

\item{method}{A Method for optimization. For more information, see \code{\link[maxLik]{maxLik}}.}

\item{verbose}{If \code{TRUE}, print the progress of the estimation.}

\item{...}{Other parameters for optimization. For more information, see \code{\link[maxLik]{maxLik}}.}
}
\value{
\code{\link{maxLik}} object
}
\description{
Generic function hfit.
A method for estimating the parameters of the exponential Hawkes model.
The reason for being constructed as the S4 method is as follows.
First, to represent the structure of the model as an hspec object.
There are numerous variations on the multivariate marked Hawkes model.
Second, to convey the starting point of numerical optimization.
The parameter values assigned to the hspec slots become initial values.
This function uses \code{\link[maxLik]{maxLik}} for the optimizer.
}
\examples{

# example 1
mu <- c(0.1, 0.1)
alpha <- matrix(c(0.2, 0.1, 0.1, 0.2), nrow=2, byrow=TRUE)
beta <- matrix(c(0.9, 0.9, 0.9, 0.9), nrow=2, byrow=TRUE)
h <- new("hspec", mu=mu, alpha=alpha, beta=beta)
res <- hsim(h, size=100)
summary(hfit(h, inter_arrival=res$inter_arrival, type=res$type))


# example 2
\donttest{
mu <- matrix(c(0.08, 0.08, 0.05, 0.05), nrow = 4)
alpha <- function(param = c(alpha11 = 0, alpha12 = 0.4, alpha33 = 0.5, alpha34 = 0.3)){
  matrix(c(param["alpha11"], param["alpha12"], 0, 0,
           param["alpha12"], param["alpha11"], 0, 0,
           0, 0, param["alpha33"], param["alpha34"],
           0, 0, param["alpha34"], param["alpha33"]), nrow = 4, byrow = TRUE)
}
beta <- matrix(c(rep(0.6, 8), rep(1.2, 8)), nrow = 4, byrow = TRUE)

impact <- function(param = c(alpha1n=0, alpha1w=0.2, alpha2n=0.001, alpha2w=0.1),
                   n=n, N=N, ...){

  Psi <- matrix(c(0, 0, param['alpha1w'], param['alpha1n'],
                  0, 0, param['alpha1n'], param['alpha1w'],
                  param['alpha2w'], param['alpha2n'], 0, 0,
                  param['alpha2n'], param['alpha2w'], 0, 0), nrow=4, byrow=TRUE)

  ind <- N[,"N1"][n] - N[,"N2"][n] > N[,"N3"][n] - N[,"N4"][n] + 0.5

  km <- matrix(c(!ind, !ind, !ind, !ind,
                 ind, ind, ind, ind,
                 ind, ind, ind, ind,
                 !ind, !ind, !ind, !ind), nrow = 4, byrow = TRUE)

  km * Psi
}
h <- new("hspec",
         mu = mu, alpha = alpha, beta = beta, impact = impact)
hr <- hsim(h, size=100)
plot(hr$arrival, hr$N[,'N1'] - hr$N[,'N2'], type='s')
lines(hr$N[,'N3'] - hr$N[,'N4'], type='s', col='red')
fit <- hfit(h, hr$inter_arrival, hr$type)
summary(fit)
}

# example 3
\donttest{
mu <- c(0.15, 0.15)
alpha <- matrix(c(0.75, 0.6, 0.6, 0.75), nrow=2, byrow=TRUE)
beta <- matrix(c(2.6, 2.6, 2.6, 2.6), nrow=2, byrow=TRUE)
rmark <- function(param = c(p=0.65), ...){
  rgeom(1, p=param[1]) + 1
}
impact <- function(param = c(eta1=0.2), alpha, n, mark, ...){
  ma <- matrix(rep(mark[n]-1, 4), nrow = 2)
  alpha * ma * matrix( rep(param["eta1"], 4), nrow=2)
}
h1 <- new("hspec", mu=mu, alpha=alpha, beta=beta,
          rmark = rmark,
          impact=impact)
res <- hsim(h1, size=100, lambda_component0 = matrix(rep(0.1,4), nrow=2))

fit <- hfit(h1,
            inter_arrival = res$inter_arrival,
            type = res$type,
            mark = res$mark,
            lambda_component0 = matrix(rep(0.1,4), nrow=2))
summary(fit)
}
# For more information, please see vignettes.
}
\seealso{
\code{\link{hspec-class}}, \code{\link{hsim,hspec-method}}
}
