% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data_functions.R
\name{ffi_read_EGM4}
\alias{ffi_read_EGM4}
\title{Read an EGM-4 data file}
\usage{
ffi_read_EGM4(file, year, tz = "UTC")
}
\arguments{
\item{file}{Filename to read, character}

\item{year}{Four-digit year of the data (EGM-4 output files have
month, day, hour, and minute, but not year), numeric or character}

\item{tz}{Time zone of the file's time data, character (optional)}
}
\value{
A \code{\link{data.frame}} with the parsed data.
}
\description{
Read an EGM-4 data file
}
\examples{
f <- system.file("extdata/EGM4-data.dat", package = "fluxfinder")
dat <- ffi_read_EGM4(f, 2023)
dat <- ffi_read_EGM4(f, 2023, tz = "EST") # specify time zone
}
