% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{subject.annot.border}
\alias{subject.annot.border}
\title{Compute annot border vertices.}
\usage{
subject.annot.border(
  subjects_dir,
  subject_id,
  hemi,
  atlas,
  surface = "white",
  expand_inwards = 0L,
  limit_to_regions = NULL
)
}
\arguments{
\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id}{string. The subject identifier.}

\item{hemi}{string, one of 'lh', 'rh', or 'both'. The hemisphere name. Used to construct the names of the label data files to be loaded.}

\item{atlas}{string. The atlas name. E.g., "aparc", "aparc.2009s", or "aparc.DKTatlas". Used to construct the name of the annotation file to be loaded.}

\item{surface}{string. The display surface. E.g., "white", "pial", or "inflated". Defaults to "white".}

\item{expand_inwards}{integer, additional thickness of the borders. Increases computation time, defaults to 0L.}

\item{limit_to_regions}{vector of character strings or NULL, a list of regions for which to draw the outline (see \code{\link[fsbrain]{get.atlas.region.names}}). If NULL, all regions will be used. If (and only if) this parameter is used, the 'outline_color' parameter can be a vector of color strings, one color per region.}
}
\value{
hemilist of integer vectors, the vertices in the border
}
\description{
Compute annot border vertices.
}
