% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kriging.R
\name{kriging}
\alias{kriging}
\title{kriging}
\usage{
kriging(x, y, z, xi, yi, svm, grid = FALSE, err = FALSE)
}
\arguments{
\item{x}{numerical vector of training data}

\item{y}{numerical vector of the same length as \code{x}}

\item{z}{numerical vector of the same length as \code{x}}

\item{xi}{scalar or vector with the \code{x}-coordinates of the
points at which the \code{z}-values are to be evaluated.}

\item{yi}{scalar or vector with the \code{y}-coordinates of the
points at which the \code{z}-values are to be evaluated.}

\item{svm}{output of the \code{\link{semivariogram}} function, a
3-element vector with the sill, nugget and range of the
semivariogram fit.}

\item{grid}{logical. If \code{TRUE}, evaluates the kriging
interpolator along a regular grid of values defined by
\code{xi} and \code{yi}.}

\item{err}{logical. If \code{TRUE}, returns the variance of the
kriging estimate.}
}
\value{
either a vector (if \code{grid=FALSE}) or a matrix (if
    \code{grid=TRUE}) of kriging interpolations. In the latter
    case, values that are more than 10\% out of the data range are
    given \code{NA} values.
}
\description{
Ordinary kriging interpolation of spatial
    data. Implements a simple version of ordinary kriging that uses
    all the data in a training set to predict the z-value of some
    test data, using a semivariogram model generated by the
    \code{\link{semivariogram}} function.
}
\examples{
data(meuse,package='geostats')
x <- meuse$x
y <- meuse$y
z <- log(meuse$cadmium)
svm <- semivariogram(x=x,y=y,z=z)
kriging(x=x,y=y,z=z,xi=179850,yi=331650,svm=svm,grid=TRUE)
}
