% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_s3_functions.R
\name{residuals.Model}
\alias{residuals.Model}
\title{Extract residuals from a `Model` object}
\usage{
\method{residuals}{Model}(object, type, conditional, ...)
}
\arguments{
\item{object}{A `Model` object.}

\item{type}{Either "standardized", "raw" or "pearson"}

\item{conditional}{Logical indicating whether to condition on the random effects (TRUE) or not (FALSE)}

\item{...}{Further arguments passed from other methods}
}
\value{
A matrix with either one column is conditional is false, or with number of columns corresponding 
to the number of MCMC samples.
}
\description{
Return the residuals from a `Model` object. This function is a wrapper for `Model$residuals()`.
Generates one of several types of residual for the model. If conditional = TRUE then 
the residuals include the random effects, otherwise only the fixed effects are included. For type,
there are raw, pearson, and standardized residuals. For conditional residuals a matrix is returned 
with each column corresponding to a sample of the random effects.
}
