% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_gmm.R
\docType{class}
\name{Gmm}
\alias{Gmm}
\alias{GmmPrior-class}
\alias{Gmm-class}
\alias{GmmPrior}
\title{Gaussian Mixture Model Prior description class}
\usage{
GmmPrior(tau = 0.01, N0 = NaN, mu = NaN, epsilon = NaN)

Gmm(tau = 0.01, N0 = NaN, mu = NaN, epsilon = NaN, alpha = 1)
}
\arguments{
\item{tau}{Prior parameter (inverse variance) default 0.01}

\item{N0}{Prior parameter (pseudo count) should be > number of features (default to NaN, in this case it will be estimated from data as the number of columns of X)}

\item{mu}{Prior parameters for the means (vector of size D), (default to NaN, in this case mu will be estimated from the data and will be equal to the mean of X)}

\item{epsilon}{Prior parameter co-variance matrix prior (matrix of size D x D), (default to a matrix of NaN, in this case epsilon will be estimated from data and will corresponds to 0.1 times a diagonal matrix with the variances of the X columns)}

\item{alpha}{Dirichlet prior parameter over the cluster proportions (default to 1)}
}
\value{
a \code{GmmPrior-class} object

a \code{Gmm-class} object
}
\description{
An S4 class to represent a multivariate Gaussian mixture model.
The model corresponds to the following generative model:
\deqn{ \pi \sim Dirichlet(\alpha)}
\deqn{ Z_i  \sim \mathcal{M}(1,\pi)}
\deqn{ V_k \sim \mathcal{W}(\varepsilon^{-1},n_0)}
\deqn{ \mu_k \sim \mathcal{N}(\mu,(\tau V_k)^{-1})}
\deqn{ X_{i}|Z_{ik}=1 \sim \mathcal{N}(\mu_k,V_{k}^{-1})}
with \eqn{\mathcal{W}(\varepsilon^{-1},n_0)} the Wishart distribution.
The \code{Gmm-class} must be used when fitting a simple Gaussian Mixture Model whereas the \code{GmmPrior-class} must be used when fitting a \code{\link{CombinedModels-class}}.
}
\examples{
GmmPrior()
GmmPrior(tau = 0.1)
Gmm()
Gmm(tau = 0.1, alpha = 0.5)
}
\references{
Bertoletti, Marco & Friel, Nial & Rastelli, Riccardo. (2014). Choosing the number of clusters in a finite mixture model using an exact Integrated Completed Likelihood criterion. METRON. 73. 10.1007/s40300-015-0064-5.
}
\seealso{
\code{\link{GmmFit-class}}, \code{\link{GmmPath-class}}

Other DlvmModels: 
\code{\link{CombinedModels}},
\code{\link{DcLbm}},
\code{\link{DcSbm}},
\code{\link{DiagGmm}},
\code{\link{DlvmPrior-class}},
\code{\link{Lca}},
\code{\link{MoM}},
\code{\link{MoR}},
\code{\link{MultSbm}},
\code{\link{Sbm}},
\code{\link{greed}()}
}
\concept{DlvmModels}
