% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_etp.R
\name{h_etp}
\alias{h_etp}
\title{Compute the potential evapotranspiration with several methods}
\source{
Hingray, B., Picouet, C., Musy A.,
Hydrologie, une science pour l'ingénieur, Presses Plolytechniques et Universitaires
Romandes, 2008,

Allen, R.G., L.S. Pereira, D. Raes, and M. Smith. 1998.
Crop Evapotranspiration. Guidelines for Computing Crop Water Requirements.
FAO Irrigation and Drainage Paper 56. 300p

Er-Raki, S., A. Chehbouni,
S. Khabba, V. Simonneaux, L. Jarlan, A. Ouldbba, J. C. Rodriguez,
and R. Allen. 2010. “Assessment of Reference Evapotranspiration Methods in
Semi-Arid Regions: Can Weather Forecast Data Be Used as Alternate of Ground
Meteorological Parameters?” Journal of Arid Environments 74 (12): 1587–96.
https://doi.org/10.1016/j.jaridenv.2010.07.002.
}
\usage{
h_etp(
  method = c("Turc", "Penman-Monteith", "Priestley-Taylor", "Makkink",
    "Heargraves-Samani"),
  freq = c("day", "month"),
  f_temp,
  f_relh = NA,
  f_radg = NA,
  f_radn = NA,
  f_atmp = NA,
  f_wvel = NA,
  f_tmin = NA,
  f_tmax = NA,
  lat = NA,
  alt = NA,
  albedo = NA,
  z = NA
)
}
\arguments{
\item{method}{Method "Turc", "Penman-Monteith", "Priestley-Taylor", "Makkink", "Heargraves-Samani"}

\item{freq}{Frequency "day", "month"}

\item{f_temp}{File of air temperature in degC, mandatory}

\item{f_relh}{File of relative humidity in percent, mandatory}

\item{f_radg}{File of global radiation in W/m2}

\item{f_radn}{File of net radiation in W/m2}

\item{f_atmp}{File of atmospheric pressure in hPa}

\item{f_wvel}{File of wind velocities in m/s}

\item{f_tmin}{File of air min temperature in degC}

\item{f_tmax}{File of air max temperature in degC}

\item{lat}{Latitude in deg}

\item{alt}{Altitude in m}

\item{albedo}{Albedo}

\item{z}{Anemometer high in m}
}
\value{
An hts files resulting of the operation with a name composed as:

<J or M><EtpTu>_<Station_id>.hts for the Turc method,

<J or M><EtpPM>_<Station_id>.hts for the Penman-Monteith method,

<J or M><EtpPT>_<Station_id>.hts for the Priestley-Taylor method

<J or M><EtpMa>_<Station_id>.hts for the Makkink method

<J or M><EtpHS>_<Station_id>.hts for the Heargraves-Samani method
}
\description{
ETP calculation
}
\details{
f_temp and f_relh are mandatory in all cases.

For the Turc method, f_radg is needed.

For the Penman-Monteith method, f_atmp, f_wvel, h and z are needed. If
f_radn is not avalaible, lat, f_tmin and ftmax are also needed.

The Turc method only works with a monthly frequence.
}
\author{
P. Chevallier - April 2020
}
