% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_inventory.R
\name{d_inventory}
\alias{d_inventory}
\title{Inventory of an htsr data base}
\usage{
d_inventory(db.sqlite, stalist = NA, form.out = NA)
}
\arguments{
\item{db.sqlite}{Data base file}

\item{stalist}{List of station ids to inventory, NA by default}

\item{form.out}{Display option: NA (console, default) or excel (xlsx) or text (csv; ou csv,)}
}
\value{
Two tables with the inventory of stations and sensors of a data base.
If the output format is an excel file, they are displayed in two sheets
of the same excel file.
}
\description{
The function produces an inventory of the stations and of sensors of an htsr data base.
If only a display is needed, the function \code{\link{d_invent}} is more convenient?
}
\details{
- stalist can contain a list of station ids, which will be inventoried with their sensors.
If stalist is NA (default), all stations containing data are processed.
Two tables are returned, one with the station main characteristics and the other one
whith the sensor data.

- form.out can take the following values : NA, "csv," text file with
'.' as decimal separator and ',' as field separator / "csv;"
text file with ',' as decimal separator and ';' as field separator
/ "xlsx" Excel file.
}
\seealso{
\code{\link{d_invent}}
}
\author{
P. Chevallier - Jan - Sep 2019
}
