% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counts2lFC.R
\name{counts2lFC}
\alias{counts2lFC}
\title{Calculate log2FoldChange}
\usage{
counts2lFC(
  countData,
  colData,
  condition,
  ref,
  type = "apeglm",
  apeAdapt = FALSE,
  ...
)
}
\arguments{
\item{countData}{a matrix of counts.}

\item{colData}{a data.frame with at least a single column. Rows of colData correspond to
columns of countData.}

\item{condition}{the formula expresses how the counts for each gene depend on the variables in
colData. The comparisons will be based on the alphabetical order of the
levels by default. You can also specify the reference level by ref parameter}

\item{ref}{specifying the reference level}

\item{type}{shrinkage estimator, default is "apeglm", the adaptive t prior shrinkage
estimator from the 'apeglm' package.}

\item{apeAdapt}{logical, should apeglm use the MLE estimates of LFC to adapt the prior, or
use default.}

\item{...}{refer to DESeq2::lfcShrink() for more detailed parameters.}
}
\value{
resLFC
a dataframe contains log2FoldChange.

# Please note this is a downsampling of the original data.
}
\description{
\code{counts2lFC} calculates log2FoldChange from counts.
}
