% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/within_network.R
\name{address_in_network}
\alias{address_in_network}
\alias{is_within}
\alias{is_within_any}
\title{Network membership of IP addresses}
\usage{
is_within(address, network)

is_within_any(address, network)
}
\arguments{
\item{address}{An \code{\link{ip_address}} vector}

\item{network}{An \code{\link{ip_network}} vector}
}
\value{
A logical vector
}
\description{
These functions check whether an IP address falls within the range
of an IP network.

\code{is_within()} performs a one-to-one matching between addresses and networks.

\code{is_within_any()} checks if each IP address falls within \emph{any} of the IP networks.
}
\examples{
is_within(ip_address("192.0.2.6"), ip_network("192.0.2.0/28"))

is_within(ip_address("192.0.3.6"), ip_network("192.0.2.0/28"))

is_within_any(ip_address("192.0.3.6"), ip_network(c("192.0.2.0/28", "192.0.3.0/28")))

}
