% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ip_address.R
\name{ip_address}
\alias{ip_address}
\alias{is_ip_address}
\alias{format.ip_address}
\alias{as.character.ip_address}
\title{Class for storing IP addresses}
\usage{
ip_address(ip = character())

is_ip_address(x)

\method{format}{ip_address}(x, ...)

\method{as.character}{ip_address}(x, ...)
}
\arguments{
\item{ip}{Character vector of IP addresses, in dot-decimal notation (IPv4)
or hexadecimal notation (IPv6).}

\item{x}{An object}

\item{...}{Additional arguments to be passed to or from methods}
}
\value{
An \code{ip_address} vector
}
\description{
\code{ip_address()} constructs a vector of IP addresses.

\code{is_ip_address()} checks if an object is of class \code{ip_address}.
}
\details{
An address in IPv4 space uses 32-bits. It is usually represented
as 4 groups of 8 bits, each shown as decimal digits (e.g. "192.168.0.1").
This is known as dot-decimal notation.

An address in IPv6 space uses 128-bits. It is usually represented
as 8 groups of 16 bits, each shown as hexadecimal digits
(e.g. "2001:0db8:85a3:0000:0000:8a2e:0370:7334"). This representation can
also be compressed by removing leading zeros and replacing consecutive
groups of zeros with double-colon (e.g. "2001:db8:85a3::8a2e:370:7334").

The \code{ip_address()} constructor accepts a character vector of IP addresses
in these two formats. It checks whether each string is a valid IPv4 or IPv6
address, and converts it to an \code{ip_address} object. If the input is invalid,
a warning is emitted and \code{NA} is stored instead.

When casting an \code{ip_address} object back to a character vector using
\code{as.character()}, IPv6 addresses are reduced to their compressed representation.
}
\examples{
# supports IPv4 and IPv6 simultaneously
ip_address(c("0.0.0.1", "192.168.0.1", "2001:db8::8a2e:370:7334"))

# validates inputs and replaces with NA
ip_address(c("1.2.3.4", "255.255.255.256", "1.2.3.4/5"))

}
