% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ip_version.R
\name{max_prefix_length}
\alias{max_prefix_length}
\title{Size of the address space}
\usage{
max_prefix_length(x)
}
\arguments{
\item{x}{An \code{\link{ip_address}} or \code{\link{ip_network}} vector}
}
\value{
An integer vector
}
\description{
The total number of bits available in the address space. IPv4 uses
32-bit addresses and IPv6 uses 128-bit addresses.
}
\examples{
x <- ip_address(c("192.168.0.1", "2001:db8::7334"))

max_prefix_length(x)
}
\seealso{
\code{\link[=is_ipv4]{is_ipv4()}}, \code{\link[=is_ipv6]{is_ipv6()}}, \code{\link[=prefix_length]{prefix_length()}}
}
