% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/komaletter.R
\name{komaletter}
\alias{komaletter}
\title{KOMA-Script LaTeX Letter Format}
\usage{
komaletter(..., keep_tex = FALSE)
}
\arguments{
\item{...}{Additional arguments to \code{\link[rmarkdown:pdf_document]{rmarkdown::pdf_document()}}}

\item{keep_tex}{A boolean toggle to select whether intermediate
LaTeX files are to be kept, defaults to \code{FALSE}}
}
\value{
R Markdown output format to pass to
\code{\link[rmarkdown:render]{rmarkdown::render()}}
}
\description{
A format for LaTeX letters via R Markdown using the KOMA-Script class
'scrlttr2'. It provides layouts for many different window envelope types
(German, US, French, Japanese, ...) and the possibility to define your own.
}
\section{Letter features}{
Various aspects of the letter can be customized via the following
variables in the R Markdown document metadata (aka YAML header).

Although it rarely makes sense to write a letter without sender and recipient,
a komaletter can be constructed by merely specifying the output format.
All other variables are optional.

Most commonly used variables:\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   author \tab Writer of the letter. \cr
   return-address \tab Address of the sender; takes a list for a multi-line address. \cr
   address \tab Name and address of the recipient; takes a list. \cr
   date \tab Custom date; if not specified, current date will be inserted. \cr
   subject \tab Subject line. \cr
   opening \tab Text for the salutation. \cr
   closing \tab Text for the complementary close, like: Best regards. \cr
   signature \tab Text (e.g. your name) or an image of your signature with \code{"\\\\includegraphics{sig.png}"}. \cr
   signature-before \tab Adjust vertical space between closing and signature by specifying a length such as \verb{2mm} or \code{"0.5\\\\baselineskip"}. \cr
}


All variables understood by \code{rmarkdown}'s \code{pdf_document} format may be used
in addition to the \code{komaletter} variables defined in the following table
to further customize your letter. For modifications of the layout please
refer to the vignette "Introduction to komaletter".

Further variables defined by komaletter:\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   lco \tab Letter Class Option File. Either name of a standard KOMA-Script LCO (e.g. DIN, SN, ) or path to custom LCO. If not specified, the \code{maintainersDelight.lco} will be used. \cr
   lang \tab Language code according to \href{https://tools.ietf.org/html/bcp47}{BCP 47} (e.g. \code{en} or \code{en-GB}). \cr
   papersize \tab Size of paper eg. \code{a4}, \code{letter}. \cr
   return-phone \tab Phone number of sender used in letter head. \cr
   return-email \tab Email address of sender used in letter head. \cr
   return-url \tab Website of sender used in letter head. \cr
   return-short \tab Shorter version of return address only used in window (see vignette \code{letter_example4}). \cr
   place \tab Sender’s place used near date. \cr
   yourref \tab Addressee’s reference as part of reference line. \cr
   yourmail \tab Date of addressee’s referenced mail as part of reference line. \cr
   myref \tab Sender’s reference as part of reference line. \cr
   customer \tab Customer number as part of reference line. \cr
   invoice \tab Invoice number as part of reference line. \cr
   cc \tab Recipients to be carbon-copied; can take a list. \cr
   encl \tab List of enclosures. \cr
   ps \tab Text to be added at the end of the letter as a postscript. \cr
   komaoption \tab Specify further KOMA options; takes a list (see \href{https://komascript.de/~mkohm/scrguien.pdf}{KOMA-Script documentation}). \cr
   parskip \tab Defines how to mark new paragraphs, e.g. full, half, off (see \href{https://komascript.de/~mkohm/scrguien.pdf}{KOMA-Script documentation}). \cr
}


The source of the example letter vignettes show several of these options in use.
}

\examples{
\dontrun{
rmarkdown::draft("my_letter.Rmd", template="pdf", package="komaletter")
rmarkdown::render("my_letter.Rmd")
}

}
\references{
JJ Allaire, Yihui Xie, Jonathan McPherson et al. (2020). rmarkdown: Dynamic Documents for R.
R package version 2.1. \url{https://cran.r-project.org/package=rmarkdown}

Aaron Wolen and Andrew Dunning (2017). pandoc-letter. GitHub Repository.
\url{https://github.com/aaronwolen/pandoc-letter}
}
