% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mhor.R
\name{mhor}
\alias{mhor}
\title{Calculating Odds Ratios}
\usage{
mhor(
  data,
  ...,
  by,
  strata = NULL,
  exp_value = NULL,
  case_value = NULL,
  plot = TRUE,
  na.rm = FALSE,
  rnd = 3
)
}
\arguments{
\item{data}{Dataset}

\item{...}{Variable or multiple variables
Colon separator \code{:} can be used to specify multiple variables.}

\item{by}{Varaiable for cross-tabulation}

\item{strata}{Variable for stratification}

\item{exp_value}{value for exposure as reference}

\item{case_value}{value for outcome as reference}

\item{plot}{logical value to display plots of odds ratios
including MH estimates across a categorical variable}

\item{na.rm}{A logical value to specify missing values, \code{NA} in the table}

\item{rnd}{specify rounding of numbers. See \code{\link{round}}.}
}
\description{
\code{mhor()} calculates odds ratios, Mantel Haenszel pooled estimates and
95\% CI.
}
\details{
Value can be set as baseline by specifying \code{exp_value}. This is used
when the exposed and case values are not in the right place.

It produces a table with Odds Ratio,95\% CI as well as
p-value. If \code{strata} is specified, \code{Mantel-Haenzsel} Pooled
estimates of \verb{Odds Ratio} is generated along with Chi-sqaured test for heterogeneity.

\strong{Odds Ratio, OR}

\deqn{OR = (D1 x H0) / (D0 x H1)}

\strong{Error Factor, EF using Woolf's formula}

\deqn{95\% CI = OR / EF or OR x EF}

\deqn{EF = exp(1.96 x SE(log(OR)))}

\deqn{SE(log(OR)) = \sqrt{1/D1 + 1/H1 + 1/D0 + 1/H0}}

\strong{Calculating p-value from Wald's z test}

\deqn{z = log OR / SE (log OR)}

\strong{Mantel-Haenszel's OR}

\deqn{ORMH = Q / R}

\deqn{Q = \sum{(D1i x H0i) / ni}}

\deqn{R = \sum{(D0i x H1i) / ni}}

\strong{Calculating CI for MH-OR}

\deqn{95\% CI = OR / EF or OR x EF}

\deqn{SE(ORMH) = \sqrt{V / (Q x R)}}

\deqn{V = \sum{(Di x Hi x n0i x n1i) / ( (ni)^2 x (ni - 1))}}

\strong{Chi-square test for MHOR, df = 1}

\deqn{X^2 (MH), Chi-square value = U^2 / V}

\deqn{U = O - E}

\deqn{O = \sum{D1i}}

\deqn{E = \sum{Di x n1i / ni}}

\strong{Chi-square test for Heterogeneity}

\deqn{X^2 = \sum{(D1i x H0i - ORMH x D0i x H1i)^2 / ORMH x Vi x ni^2}}
}
\examples{


### Example from Essential Medical Statistics
# Page 178, Chapter 18: Controlling for confounding: Stratification
lepto <- expandTables(
    male = c(36, 14, 50, 50), female = c(24, 126, 10, 90),
    exp_name = "area", exp_lvl = c("Rural", "Urban"),
    case_name = "ab", case_lvl = c("Yes", "No"),
    strata_name = "gender"
)

## label variables and data
lepto <- labelData(lepto, "Prevalence survey of leptospirosis in West Indies")
lepto <- labelVar(lepto,
              c(area, ab, gender),
              c("Type of area", "Leptospirosis Antibodies",
                "Gender: Male or female"))

## check dataset
codebook(lepto)

## Calculate OR
mhor(lepto, area, by = ab, case_value = "Yes")

}
\references{
\enumerate{
\item Betty R. Kirkwood, Jonathan A.C. Sterne (2006, ISBN:978–0–86542–871–3)
\item B. Burt Gerstman (2013, ISBN:978-1-4443-3608-5)
\item Douglas G Altman (2005, ISBN:0 7279 1375 1)
}
}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
