% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_iucn.R
\name{species_richness}
\alias{species_richness}
\alias{calc_species_richness}
\title{Species richness based on IUCN raster data}
\usage{
calc_species_richness(engine = "extract", stats = "mean")
}
\arguments{
\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}

\item{stats}{Function to be applied to compute statistics for polygons either
one or multiple inputs as character. Supported statistics are: "mean",
"median", "sd", "min", "max", "sum" "var".}
}
\value{
A function that returns an indicator tibble with IUCN layers with
specified statistics as variable and respective species richness (count)
as value.
}
\description{
Species richness counts the number of potential species intersecting with a
polygon grouped by the IUCN threat categorization. Note, that
this indicator function requires the manual download of the respective
raster files.
}
\details{
The specific meaning of the species richness indicator depends on the
supplied raster file.

The required resources for this indicator are:
\itemize{
\item \link{iucn}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

iucn_dir <- system.file("res", "iucn", package = "mapme.biodiversity")
sr_rasters <- list.files(iucn_dir, pattern = "*_SR_*", full.names = TRUE)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(get_iucn(sr_rasters)) \%>\%
  calc_indicators(calc_species_richness(stats = "median")) \%>\%
  portfolio_long()

aoi
}
}
\keyword{indicator}
