% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micomp.R
\name{summary.assumptions_micomp}
\alias{summary.assumptions_micomp}
\title{Summary method for the assumptions of parametric tests used in multiple
comparisons of outputs}
\usage{
\method{summary}{assumptions_micomp}(object, ...)
}
\arguments{
\item{object}{Object of class \code{assumptions_micomp}.}

\item{...}{Currently ignored.}
}
\value{
A list in which each component is associated with a distinct
comparison. Each component contains a matrix, in which columns represent
individual outputs and rows correspond to the statistical tests evaluating
the assumptions of the parametric tests used in each output. More
specifically, each matrix has rows with the following information:
\describe{
 \item{Royston (\emph{group}, \emph{ve=\%/npcs=})}{One row per group per
       variance to explain / number of PCs, with the \emph{p}-value yielded
       by the Royston test (\code{\link[MVN]{mvn}}) for the
       respective group and variance/npcs combination.}
 \item{Box's M (\emph{ve=\%/npcs=})}{One row per variance to explain with the
       \emph{p}-value yielded by Box's M test
       (\code{\link[biotools]{boxM}}).}
 \item{Shapiro-Wilk (\emph{group})}{One row per group, with the
       \emph{p}-value yielded by the Shapiro-Wilk test
       (\code{\link[stats]{shapiro.test}}) for the respective group.}
 \item{Bartlett}{One row with the \emph{p}-value yielded by Bartlett's test
       (\code{\link[stats]{bartlett.test}}).}
}
}
\description{
Summary method for objects of class \code{assumptions_micomp}, which
contain the assumptions for the parametric tests used in multiple comparisons
of outputs.
}
\examples{
\donttest{
# Create a micomp object, use provided dataset
mic <- micomp(5, c(0.7, 0.8, 0.9),
              list(list(name = "NLOKvsJEXOK", grpout = pphpc_ok),
                   list(name = "NLOKvsJEXNOSHUFF", grpout = pphpc_noshuff)),
              concat = TRUE)

# Get the assumptions summary
sam <- summary(assumptions(mic))
}
}
