% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download-rmd.R
\name{download_rmd_button}
\alias{download_rmd_button}
\title{Generate an HTML widget to download input Rmd file}
\usage{
download_rmd_button(
  input = NULL,
  text = "Download Rmd",
  ...,
  class = "button",
  align = "right",
  aside = TRUE,
  embed = xfun::embed_file
)
}
\arguments{
\item{input}{Filename of the input. If \code{NULL}, the function automatically
detects the name of the knitting Rmd file.}

\item{text}{The text for the hyperlink.}

\item{...}{Arguments passed to the \code{embed} function.}

\item{class}{HTML class(es) given to the anchor element generated by \code{embed}
(default: "button").}

\item{align}{Align the button by CSS's \code{text-align} attribute.
This feature is disabled when aside is \code{FALSE}}

\item{aside}{Whether to wrap the anchor element by the aside element.}

\item{embed}{A function to embed file(s).
One of \code{xfun::embed_file}, \code{xfun::embed_files}, or \code{xfun::embed_dir}.}
}
\value{
\code{shiny.tag} class object.
}
\description{
The button can self-contain the input data by base64 encoding.
}
\examples{
set.seed(1L)

input <- tempfile()
writeLines("", input)
download_rmd_button(input)

# Requires zip command
if (interactive()) {
  input <- tempdir()
  download_rmd_button(input, embed = xfun::embed_dir)
}
}
