% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IA_tab.R
\name{R2M}
\alias{R2M}
\alias{R2M.nls}
\alias{R2M.lm}
\alias{R2M.gls}
\alias{R2M.gnls}
\alias{R2M.lme}
\alias{R2M.nlme}
\title{R-squared for nonlinear mixed models}
\usage{
R2M(x, ...)

\method{R2M}{nls}(x, ...)

\method{R2M}{lm}(x, ...)

\method{R2M}{gls}(x, ...)

\method{R2M}{gnls}(x, ...)

\method{R2M}{lme}(x, ...)

\method{R2M}{nlme}(x, ...)
}
\arguments{
\item{x}{object of class \sQuote{lm}, \sQuote{nls}, \sQuote{gls}, \sQuote{gnls}, 
\sQuote{lme} or \sQuote{nlme} .}

\item{...}{additional arguments (none use at the moment).}
}
\value{
it returns a list with the following structure: \cr
for an object of class \sQuote{lm}, \sQuote{nls}, \sQuote{gls} or \sQuote{gnls}, \cr
R2: R-squared \cr
var.comp: variance components with var.fixed and var.resid \cr
var.perc: variance components percents (should add up to 100) \cr
for an object of class \sQuote{lme} or \sQuote{nlme} in addition it also returns: \cr
R2.marginal: marginal R2 which only includes the fixed effects \cr
R2.conditional: conditional R2 which includes both the fixed and random effects \cr
var.random: the variance contribution of the random effects
}
\description{
R-squared \sQuote{modified} for nonlinear (mixed) models
}
\details{
I have read some papers about computing an R-squared for (non)linear (mixed) models
and I am not sure that it makes sense at all. However, here they are and
the method is general enough that it extends to nonlinear mixed models. What do
these numbers mean and why would you want to compute them are good questions to 
ponder... \cr

Recommended reading: \cr
Nakagawa and Schielzeth Methods in Ecology and Evolution \doi{10.1111/j.2041-210x.2012.00261.x} \cr

\url{https://stats.oarc.ucla.edu/other/mult-pkg/faq/general/faq-what-are-pseudo-r-squareds/} \cr

Spiess, AN., Neumeyer, N. An evaluation of R2 as an inadequate measure for nonlinear models in 
pharmacological and biochemical research: a Monte Carlo approach. BMC Pharmacol 10, 6 (2010). 
\doi{10.1186/1471-2210-10-6} \cr

\url{https://stat.ethz.ch/pipermail/r-sig-mixed-models/2010q1/003363.html} \cr

\url{https://blog.minitab.com/en/adventures-in-statistics-2/why-is-there-no-r-squared-for-nonlinear-regression} \cr

\url{https://stats.stackexchange.com/questions/111150/calculating-r2-in-mixed-models-using-nakagawa-schielzeths-2013-r2glmm-me/225334#225334} \cr
 
Other R pacakges which calculate some version of an R-squared: performance, rcompanion, MuMIn
}
\note{
The references here strongly discourage the use of R-squared in anything
but linear models.
}
\examples{
\donttest{
require(nlme)
data(barley, package = "nlraa")
fit2 <- lme(yield ~ NF + I(NF^2), random = ~ 1 | year, data = barley)
R2M(fit2)
## Nonlinear Mixed Model
barleyG <- groupedData(yield ~ NF | year, data = barley)
fit3L <- nlsLMList(yield ~ SSquadp3(NF, a, b, c), data = barleyG)
fit3 <- nlme(fit3L, random = pdDiag(a + b ~ 1))
R2M(fit3)
}
}
\seealso{
\code{\link{IA_tab}}
}
