% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{geoOutliers}
\alias{geoOutliers}
\title{Detect geographic outliers}
\usage{
geoOutliers(
  df,
  xf,
  yf,
  .alpha.parameter,
  .distance.parameter = 1000,
  .medianDeviation.parameter = 5,
  .samplingIntensThreshold.parameter = 0.1,
  method = "all",
  .projString,
  do = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{df}{data.frame of species occurrences}

\item{xf}{character. column name in df containing the x coordinates}

\item{yf}{character. column name in df containing the y coordinates}

\item{.alpha.parameter}{parameter setting for alphahull}

\item{.distance.parameter}{numeric. Maximum distance allowed. Default to 1000}

\item{.medianDeviation.parameter}{numeric. Deviation parameter to . Default to 0.1}

\item{method}{charcter. Vector of methods to be used. See details. Default 'all'}

\item{.projString}{proj4string character. Indicate coordinate reference system}

\item{do}{logical. Should tests be performed? Default TRUE}

\item{verbose}{logical. Print messages? Default FALSE}
}
\value{
data.frame
}
\description{
Detect geographic outliers
}
\details{
Methods implented are 'alphaHull', detecting species outside an alphaHull level (default 2), \cr
'alphaHull' \cr
'distance' corresponds to 'distance' method in  CoordinateCleaner::cc_outl(method='distance'). See ?CoordinateCleaner::cc_outl \cr
'median' corresponds to 'mad' method in  CoordinateCleaner::cc_outl(method='mad'). See ?CoordinateCleaner::cc_outl \cr
'quantSamplingCorrected' corresponds to 'mad' method in  CoordinateCleaner::cc_outl(method='quantile'). See ?CoordinateCleaner::cc_outl \cr
'grubbs' implements Grubbs test to find spatial outliers. See ?findSpatialOutliers for details \cr
}
\seealso{
getPointsOutAlphaHull, \link[CoordinateCleaner]{cc_outl}, findSpatialOutliers
}
\author{
Josep M Serra-Diaz (pep.serradiaz@agroparistech.fr), Cory Merow (cmerow@gmail.com)
}
\keyword{internal}
