% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{write_plot_file}
\alias{write_plot_file}
\title{Create the OGRDB style plot file}
\usage{
write_plot_file(
  filename,
  input_sequences,
  cdr3_dist_grobs,
  end_composition_grobs,
  cons_composition_grobs,
  whole_composition_grobs,
  triplet_composition_grobs,
  barplot_grobs,
  a_allele_plot,
  haplo_grobs,
  message,
  format
)
}
\arguments{
\item{filename}{name of file to create (pdf)}

\item{input_sequences}{the input_sequences data frame}

\item{cdr3_dist_grobs}{cdr3 length distribution grobs created by make_novel_base_grob}

\item{end_composition_grobs}{end composition grobs created by make_novel_base_grobs}

\item{cons_composition_grobs}{consensus composition grobs created by make_novel_base_grobs}

\item{whole_composition_grobs}{whole composition grobs created by make_novel_base_grobs}

\item{triplet_composition_grobs}{triplet composition grobs created by make_novel_base_grobs}

\item{barplot_grobs}{barplot grobs created by make_barplot_grons}

\item{a_allele_plot}{a_allele_plot grob created by make_haplo_grobs}

\item{haplo_grobs}{haplo_grobs created by make_haplo_grobs}

\item{message}{text message to display at end of report}

\item{format}{Format of report ('pdf', 'html' or 'none')}
}
\value{
None
}
\description{
Create the OGRDB style plot file
}
\examples{
plot_file = tempfile(pattern = 'ogrdb_plots')

base_grobs = make_novel_base_grobs(
                 example_rep$inferred_seqs,
                 example_rep$input_sequences,
                 'V',
                 FALSE
             )
barplot_grobs = make_barplot_grobs(
                      example_rep$input_sequences,
                      example_rep$genotype_db,
                      example_rep$inferred_seqs,
                      example_rep$genotype,
                      'V',
                      example_rep$calculated_NC
               )
haplo_grobs = make_haplo_grobs('V', example_rep$haplo_details)

write_plot_file(
    plot_file,
    example_rep$input_sequences,
    base_grobs$cdr3_dist,
    base_grobs$end,
    base_grobs$conc,
    base_grobs$whole,
    base_grobs$triplet,
    barplot_grobs,
    haplo_grobs$aplot,
    haplo_grobs$haplo,
    "Notes on this analysis",
    'none'
)

file.remove(plot_file)
}
