% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remote.R
\name{orderly_remote_status}
\alias{orderly_remote_status}
\title{Get status of remote queue.}
\usage{
orderly_remote_status(root = NULL, locate = TRUE, remote = NULL)
}
\arguments{
\item{root}{The path to an orderly root directory, or \code{NULL}
(the default) to search for one from the current working
directory if \code{locate} is \code{TRUE}.}

\item{locate}{Logical, indicating if the configuration should be
searched for.  If \code{TRUE} and \code{config} is not given,
then orderly looks in the working directory and up through its
parents until it finds an \code{orderly_config.yml} file.}

\item{remote}{Description of the location.  Typically this is a
character string indicating a remote specified in the
\code{remotes} block of your \code{orderly_config.yml}.  It is
also possible to pass in a directly created remote object (e.g.,
using \code{\link[=orderly_remote_path]{orderly_remote_path()}}, or one provided by
another package).  If left \code{NULL}, then the default remote
for this orderly repository is used - by default that is the
first listed remote.}
}
\value{
List containing details of running and queued reports on the
remote queue. Including report name, status and version (where known)
}
\description{
Get the status of the remote queue as a list.
}
