\name{pacotestRvineSeq}
\alias{pacotestRvineSeq}

\title{
Sequentially Testing the Simplifying Assumption for R-Vine Copulas
}

\description{
The function can be used to test the simplifying assumption for R-vine copulas in a sequential manner. Each pair-copula from the second tree on is tested to be a (j-1)-th order partial copula. To apply the function one needs to provide the data and a specified/estimated R-vine copula model in form of a \link[VineCopula]{RVineMatrix} from the \link[VineCopula]{VineCopula-package}. Additionally, a pacotest options list, which can be generated with the \code{\link{pacotestset}} function, needs to be provided.
}
\usage{
pacotestRvineSeq(data, RVM, pacotestOptions,
  level = 0.05, illustration = 2, stopIfRejected = TRUE)
}

\arguments{
  \item{data}{
  A (n x d) matrix (or data frame) of [0,1] data (i.e. uniform margins).
  }
  \item{RVM}{
  An \link[VineCopula]{RVineMatrix} object (\link[VineCopula]{VineCopula-package}) which includes the structure, the pair-copula families and parameters of an R-vine copula.
  }
  \item{pacotestOptions}{
  A options list generated by the \code{\link{pacotestset}} function or the test type as string, i.e., \code{CCC} or \code{VI}.
  }
  \item{level}{
The level of the test.
}
  \item{illustration}{
Either 1 or 2. If illustration = 1, the p-value for each test for a (j-1)-th order partial copula is displayed. If illustration = 2, a progress information is displayed for each tree. It consists of the individual test level and the number of H0 rejections.
}
  \item{stopIfRejected}{
  A logical variable indicating whether the sequential test procedure should be stopped in the first tree where an H0 for one of the conditional copulas is rejected.
  }

}

\value{
A list consisting of the following elements:
\item{pacotestResultLists}{
A matrix in the same structure like the \code{Matrix}, \code{family}, \code{par}, etc. entries in the \link[VineCopula]{RVineMatrix} object from the \link[VineCopula]{VineCopula-package}. Each entry of the matrix is a list containing the test result from a test for a (j-1)-th order partial copula obtained from a call to \code{\link{pacotest}}. Depending on the chosen test, it could consist of different elements. A documentation of the \code{pacotestResultLists} can be found in the documentation of \code{\link{pacotest}}.
}
\item{pValues}{
A matrix in the same structure like the \code{Matrix}, \code{family}, \code{par}, etc. entries in the \link[VineCopula]{RVineMatrix} object from the \link[VineCopula]{VineCopula-package}. Each entry of the matrix is a p-value corresponding to the test result from a test for a (j-1)-th order partial copula.
}
\item{testResultSummary}{
A data.frame summarizing the test results.
The first column, \code{Tree}, is the tree number.
The second column, \code{NumbOfRejections}, is the number of of rejections in the corresponding tree.
The third column, \code{IndividualTestLevel}, is the level at which each individual test has been performed.
The fourth column, \code{Interpretation}, provides an interpretation of the test result.
}
}

\author{
Malte S. Kurz
}

\seealso{
\code{\link{pacotest-package}}, \code{\link{pacotest}}, \code{\link{pacotestset}}, \code{\link{pacotestRvineSingleCopula}}
}

\references{
Kurz, M. S. and F. Spanhel (2022), "Testing the simplifying assumption in high-dimensional vine copulas", Electronic Journal of Statistics 16 (2), pp. 5226-5276.

Spanhel, F. and M. S. Kurz (2019), "Simplified vine copula models: Approximations based on the simplifying assumption", Electronic Journal of Statistics 13 (1), pp. 1254-1291.
}

\examples{
\donttest{# Sample data and R-vine copula selection are taken
# from the documentation of RVineStructureSelect
# of the VineCopula package.

# Obtain sample data
data(daxreturns, package ="VineCopula")
dataSet = daxreturns[1:750,1:4]

# Specify an R-vine copula model
# (can be obtained by calling: RVM = VineCopula::RVineStructureSelect(dataSet))
vineStructure = matrix(c(3,4,1,2,0,2,4,1,0,0,1,4,0,0,0,4),4,4)
families = matrix(c(0,5,2,2,0,0,2,14,0,0,0,14,0,0,0,0),4,4)
par = matrix(c(0,0.8230664,0.1933472,0.6275062,
             0,0,0.2350109,1.6619945,
             0,0,0,1.599363,
             0,0,0,0),4,4)
par2 = matrix(c(0,0,11.757700,4.547847,
             0,0,17.15717,0,
             0,0,0,0,0,0,0,0),4,4)
RVM = VineCopula::RVineMatrix(vineStructure, families, par, par2)


# Specify a pacotestOptions list:
pacotestOptions = pacotestset('CCC')

# Test for the simplifying assumption.
pacotestResultList = pacotestRvineSeq(dataSet, RVM,
                                      pacotestOptions)}
}

