% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage.plot.r
\name{coverage_plot}
\alias{coverage_plot}
\title{coverage_plot}
\usage{
coverage_plot(spp, fos, n2_rare = 5, label = NULL)
}
\arguments{
\item{spp}{data.frame of modern species abundances}

\item{fos}{data.frame of fossil species abundances}

\item{n2_rare}{numeric value of Hill's N2 below which species are
highlighted as rare}

\item{label}{numeric label taxa where maximum fossil abundance -
maximum modern abundance > label.
Defaults to NULL which does not add labels}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
A simple diagnostic plot showing the coverage of fossil taxa in
modern calibration set
}
\details{
Finds the maximum abundance of fossil taxa and plots this against
the maximum abundance the taxa in the modern calibration set.
Taxa with a Hill's N2 less than \code{rare} in the calibration set are
highlighted in blue.
Taxa absent from the calibration set are highlighted in red.
If there are many taxa above the 1:1 line, or important fossil taxa have a
low N2 in the calibration set,
reconstructions should be interpreted with caution.
}
\examples{
data("SWAP", package = "rioja")
data("RLGH", package = "rioja")
coverage_plot(spp = SWAP$spec, fos = RLGH$spec, n2_rare = 5, label = 0)

}
