% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotMutInteract}
\alias{plotMutInteract}
\title{Exact tests to detect mutually exclusive, co-occuring and altered genesets or pathways.}
\usage{
plotMutInteract(
  freq_matrix,
  genes,
  pvalue = c(0.05, 0.01),
  returnAll = TRUE,
  fontSize = 0.8,
  showSigSymbols = TRUE,
  showCounts = FALSE,
  countStats = "all",
  countType = "all",
  countsFontSize = 0.8,
  countsFontColor = "black",
  colPal = "BrBG",
  nShiftSymbols = 5,
  sigSymbolsSize = 2,
  sigSymbolsFontSize = 0.9,
  pvSymbols = c(46, 42),
  limitColorBreaks = TRUE
)
}
\arguments{
\item{freq_matrix}{The mutations matrix,generated by `get_mut_matrix`.}

\item{genes}{List of genes or pathways among which interactions should be tested.}

\item{pvalue}{Default c(0.05, 0.01) p-value threshold. You can provide two values for upper and lower threshold.}

\item{returnAll}{If TRUE returns test statistics for all pair of tested genes. Default FALSE, returns for only genes below pvalue threshold.}

\item{fontSize}{cex for gene names. Default 0.8.}

\item{showSigSymbols}{Default TRUE. Heighlight significant pairs.}

\item{showCounts}{Default TRUE. Include number of events in the plot.}

\item{countStats}{Default 'all'. Can be 'all' or 'sig'.}

\item{countType}{Default 'cooccur'. Can be 'all', 'cooccur', 'mutexcl'.}

\item{countsFontSize}{Default 0.8.}

\item{countsFontColor}{Default 'black'.}

\item{colPal}{colPalBrewer palettes. See RColorBrewer::display.brewer.all() for details.}

\item{nShiftSymbols}{shift if positive shift SigSymbols by n to the left, default = 5.}

\item{sigSymbolsSize}{size of symbols in the matrix and in legend.}

\item{sigSymbolsFontSize}{size of font in legends.}

\item{pvSymbols}{vector of pch numbers for symbols of p-value for upper and lower thresholds c(upper, lower).}

\item{limitColorBreaks}{limit color to extreme values. Default TRUE.}
}
\value{
list of data.tables
}
\description{
Performs Pair-wise Fisher's Exact test to detect mutually exclusive or co-occuring events.
}
\examples{
#get the path of the mutation annotation file and samples' survival data
maf<-system.file("extdata","data_mutations_extended.txt",package = "pathwayTMB")
sur_path<-system.file("extdata","sur.csv",package = "pathwayTMB")
sur<-read.csv(sur_path,header=TRUE,row.names = 1)
#perform the function 'get_mut_matrix'
\donttest{mut_matrix<-get_mut_matrix(maffile=maf,mut_fre = 0.01,is.TCGA=FALSE,sur=sur)
#perform the function `get_PTMB`
PTMB_matrix<-get_PTMB(freq_matrix=mut_matrix,genesmbol=genesmbol,gene_path=gene_path)
set.seed(1)
final_character<-get_final_signature(PTMB=PTMB_matrix,sur=sur)
plotMutInteract(freq_matrix=PTMB_matrix, genes=final_character,nShiftSymbols =0.3)}
}
