% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitGrowth.R
\name{fitGrowthbrms}
\alias{fitGrowthbrms}
\alias{fitGrowthbrmsgam}
\title{Ease of use brms wrapper function for fitting growth models specified by \code{growthSS}}
\usage{
fitGrowthbrms(
  ss,
  iter = 2000,
  cores = getOption("mc.cores", 1),
  chains = 4,
  prior = NULL,
  backend = "cmdstanr",
  silent = 0,
  ...
)

fitGrowthbrmsgam(
  ss,
  iter = 2000,
  cores = getOption("mc.cores", 1),
  chains = 4,
  prior = NULL,
  backend = "cmdstanr",
  silent = 0,
  ...
)
}
\arguments{
\item{ss}{A list generated by \code{growthSS}.}

\item{iter}{A number of iterations to sample for each chain.
By default half this length is taken as warm-up for the MCMC algorithm.
This defaults to 2000.}

\item{cores}{A number of cores to run in parallel.
This defaults to 1 if the "mc.cores" option is not set.
Generally this is specified as one core per chain so that the model is fit in parallel.}

\item{chains}{A number of markov chains to use, this defaults to 4.}

\item{prior}{A \code{brmsprior} object if \code{growthSS} did not have priors specified.
If left NULL (the default) and ss does not contain priors then a warning is
issued but the model will still attempt to fit.}

\item{backend}{A backend for brms to use Stan through.
This defaults to use "cmdstanr".}

\item{silent}{Passed to \code{brms::brm} to control verbosity.
This defaults to 0, the most verbose option so that messages and progress are printed.
With changes to \code{cmdstanr} and \code{brms} this may be removed, but the option
will be available through \code{...}. Note that this is likely to print lots of
messages during warmup iterations as the MCMC gets started.}

\item{...}{Additional arguments passed to \code{brms::brm}.}
}
\value{
A \code{brmsfit} object, see \code{?`brmsfit-class`} for details.
}
\description{
Helper function generally called from \link{fitGrowth}.
}
\keyword{Bayesian}
\keyword{brms}
