% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesTheorem.R
\name{pA}
\alias{pA}
\alias{pB}
\alias{pAgivenB}
\alias{pBgivenA}
\alias{pAgivenNotB}
\alias{pBgivenNotA}
\title{Bayes' Theorem.}
\usage{
pA(pAgivenB, pB, pAgivenNotB)

pB(pBgivenA, pA, pBgivenNotA)

pAgivenB(pBgivenA, pA, pB = NULL, pBgivenNotA = NULL)

pBgivenA(pAgivenB, pB, pA = NULL, pAgivenNotB = NULL)

pAgivenNotB(pAgivenB, pA, pB)

pBgivenNotA(pBgivenA, pA, pB)
}
\arguments{
\item{pAgivenB}{The conditional probability of \code{A} given \code{B}.}

\item{pB}{The marginal probability of event \code{B}.}

\item{pAgivenNotB}{The conditional probability of \code{A} given NOT
\code{B}.}

\item{pBgivenA}{The conditional probability of \code{B} given \code{A}.}

\item{pA}{The marginal probability of event \code{A}.}

\item{pBgivenNotA}{The conditional probability of \code{B} given NOT
\code{A}.}
}
\value{
The requested marginal or conditional probability. One of:
\itemize{
  \item the marginal probability of \code{A}
  \item the marginal probability of \code{B}
  \item the conditional probability of \code{A} given \code{B}
  \item the conditional probability of \code{B} given \code{A}
  \item the conditional probability of \code{A} given NOT \code{B}
  \item the conditional probability of \code{B} given NOT \code{A}
}
}
\description{
Estimate marginal and conditional probabilities using Bayes theorem.
}
\details{
Estimates marginal or conditional probabilities using Bayes theorem.
}
\examples{
pA(pAgivenB = .95, pB = .285, pAgivenNotB = .007171515)

pB(pBgivenA = .95, pA = .285, pBgivenNotA = .007171515)

pAgivenB(pBgivenA = .95, pA = .285, pB = .2758776)
pAgivenB(pBgivenA = .95, pA = .285, pBgivenNotA = .007171515)
pAgivenB(pBgivenA = .95, pA = .003, pBgivenNotA = .007171515)

pBgivenA(pAgivenB = .95, pB = .285, pA = .2758776)
pBgivenA(pAgivenB = .95, pB = .285, pAgivenNotB = .007171515)
pBgivenA(pAgivenB = .95, pB = .003, pAgivenNotB = .007171515)

pAgivenNotB(pAgivenB = .95, pB = .003, pA = .01)

pBgivenNotA(pBgivenA = .95, pA = .003, pB = .01)
}
\seealso{
Other bayesian: 
\code{\link{deriv_d_negBinom}()}
}
\concept{bayesian}
