% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/water.et.r
\name{ET_ref}
\alias{ET_ref}
\alias{ET_ref_day}
\title{Evapotranspiration}
\usage{
ET_ref(
  temperature,
  water.vp,
  wind.speed,
  net.irradiance,
  nighttime = FALSE,
  atmospheric.pressure = 10.13,
  soil.heat.flux = 0,
  method = "FAO.PM",
  check.range = TRUE
)

ET_ref_day(
  temperature,
  water.vp,
  wind.speed,
  net.radiation,
  atmospheric.pressure = 10.13,
  soil.heat.flux = 0,
  method = "FAO.PM",
  check.range = TRUE
)
}
\arguments{
\item{temperature}{numeric vector of air temperatures (C) at 2 m height.}

\item{water.vp}{numeric vector of water vapour pressure in air (Pa).}

\item{wind.speed}{numeric Wind speed (m/s) at 2 m height.}

\item{net.irradiance}{numeric Long wave and short wave balance (W/m2).}

\item{nighttime}{logical Used only for methods that distinguish between
daytime- and nighttime canopy conductances.}

\item{atmospheric.pressure}{numeric Atmospheric pressure (Pa).}

\item{soil.heat.flux}{numeric Soil heat flux (W/m2), positive if soil
temperature is increasing.}

\item{method}{character The name of an estimation method.}

\item{check.range}{logical Flag indicating whether to check or not that
arguments for temperature are within range of method. Passed to
function calls to \code{water_vp_sat()} and \code{water_vp_sat_slope()}.}

\item{net.radiation}{numeric Long wave and short wave balance (J/m2/day).}
}
\value{
A numeric vector of reference evapotranspiration estimates expressed
  in mm/h for \code{ET_ref()} and in mm/d for \code{ET_ref_day()}.
}
\description{
Compute an estimate of reference (= potential) evapotranspiration from
meteorologial data. Evapotranspiration from vegetation includes
transpiraction by plants plus evaporation from the soil or other wet
surfaces. \eqn{ET_0} is the reference value assuming no limitation to
transpiration due to soil water, similar to potential evapotranspiration
(PET). An actual evapotranpiration value \eqn{ET} can be estimated only if
additional information on the plants and soil is available.
}
\details{
Currently three methods, based on the Penmann-Monteith equation
  formulated as recommended by FAO56 (Allen et al., 1998) as well as modified
  in 2005 for tall and short vegetation according to ASCE-EWRI are
  implemented in function \code{ET_ref()}. The computations rely on data
  measured according WHO standards at 2 m above ground level to estimate
  reference evapotranspiration (\eqn{ET_0}). The formulations are those for
  ET expressed in mm/h, but modified to use as input flux rates in W/m2 and
  pressures expressed in Pa.
}
\examples{
# instantaneous
ET_ref(temperature = 20,
       water.vp = water_RH2vp(relative.humidity = 70,
                              temperature = 20),
       wind.speed = 0,
       net.irradiance = 10)

ET_ref(temperature = c(5, 20, 35),
       water.vp = water_RH2vp(70, c(5, 20, 35)),
       wind.speed = 0,
       net.irradiance = 10)

# Hot and dry air
ET_ref(temperature = 35,
       water.vp = water_RH2vp(10, 35),
       wind.speed = 5,
       net.irradiance = 400)

ET_ref(temperature = 35,
       water.vp = water_RH2vp(10, 35),
       wind.speed = 5,
       net.irradiance = 400,
       method = "FAO.PM")

ET_ref(temperature = 35,
       water.vp = water_RH2vp(10, 35),
       wind.speed = 5,
       net.irradiance = 400,
       method = "ASCE.PM.short")

ET_ref(temperature = 35,
       water.vp = water_RH2vp(10, 35),
       wind.speed = 5,
       net.irradiance = 400,
       method = "ASCE.PM.tall")

# Low temperature and high humidity
ET_ref(temperature = 5,
       water.vp = water_RH2vp(95, 5),
       wind.speed = 0.5,
       net.irradiance = -10,
       nighttime = TRUE,
       method = "ASCE.PM.short")

ET_ref_day(temperature = 35,
           water.vp = water_RH2vp(10, 35),
           wind.speed = 5,
           net.radiation = 35e6) # 35 MJ / d / m2

}
\references{
Allen R G, Pereira L S, Raes D, Smith M. 1998. Crop evapotranspiration:
    Guidelines for computing crop water requirements. Rome: FAO.

 Allen R G, Pruitt W O, Wright J L, Howell T A, Ventura F, Snyder R,
    Itenfisu D, Steduto P, Berengena J, Yrisarry J, et al. 2006. A
    recommendation on standardized surface resistance for hourly calculation
    of reference ETo by the FAO56 Penman-Monteith method. Agricultural Water
    Management 81.
}
\seealso{
Other Evapotranspiration and energy balance related functions.: 
\code{\link{net_irradiance}()}
}
\concept{Evapotranspiration and energy balance related functions.}
