% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.protoclust.R
\name{as.protoclust}
\alias{as.protoclust}
\title{Convert a generic hclust object to a protoclust object.}
\usage{
as.protoclust(hc, protos)
}
\arguments{
\item{hc}{A generic hclust object using any linkage.}

\item{protos}{A vector of prototype label indices for each branch in the dendrogram.
The i-th element is the index of the prototype corresponding to the cluster 
formed on the i-th merge.}
}
\value{
An object of class \code{\link{protoclust}} with a user specified vector of representative prototypes for each cluster.
        This object is just like \code{hclust} but has an identical element:
        \item{merge, height,order}{identical to the values returned by \code{\link{hclust}}}
        \item{protos}{a vector of length n - 1.  The i-th element is the index of
                      the prototype corresponding to the cluster formed on the i-th merge.}
}
\description{
Convert a generic hclust object to a protoclust object.
}
