% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psid_unzip.R
\name{psid_unzip}
\alias{psid_unzip}
\title{Unzip and transfer the downloaded PSID data files}
\usage{
psid_unzip(indir, exdir, zipped = TRUE, type = "package", filename = NA)
}
\arguments{
\item{indir}{A string value of the directory path where the user store the downloaded data files.}

\item{exdir}{A string value of the directory path where the user wish to put the generated \code{.rda} files.}

\item{zipped}{A logic value indicating whether the data files are zipped or not.}

\item{type}{A string value of either "package" or "single", indicating whether the data files are packaged data file or a single customized dataset with only selected variables.}

\item{filename}{A string value of the name of the single file. Default to be NA, but requires to be specified if the type is "single"}
}
\value{
\code{.rda} data files stored in the specified directory file folder
}
\description{
This \code{psid_unzip()} function streamlines the process of transforming ASCII data downloaded from the PSID website to R data files (.rda).
}
\details{
This function executes two primary operations:
\itemize{
\item Unzip the zipped data files
\item Converts the ASCII file into a \code{.rda} format for the reading steps
}

For optimal functionality, please ensure that you have satisfied the following prerequisites:
\itemize{
\item If you are using packaged data files, please do not make any changes to the name of the data files
\item If you download the dataset with only selected variables, please choose \verb{ASCII Data With SAS Statements} as the data output type
}

The user will only need to execute this function once.
If you have already executed this function before and have all the \code{.rda} files settled down, you do not have to run this again.
This function may take several minutes if you have multiple packaged file to unzip and convert.
}
\examples{
# Example 1: Unzip and convert packaged files
exdir <- system.file(package = "psidread","extdata") # Define the export directory
indir <- system.file(package = "psidread","extdata") # Define the input directory
psid_unzip(indir = indir, exdir = exdir, zipped = TRUE, type = "package", filename = NA)
# Example 2: Unzip and convert customized single data files
exdir <- system.file(package = "psidread","extdata") # Define the input directory
indir <- system.file(package = "psidread","extdata") # Define the output directory
filename = "J327825.zip"
psid_unzip(indir = indir, exdir = exdir, zipped = TRUE, type = "single", filename = filename)
}
