% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psid_reshape.R
\name{psid_reshape}
\alias{psid_reshape}
\title{Rename and reshape your PSID dataset}
\usage{
psid_reshape(psid_df, str_df, shape = "wide", level = "individual")
}
\arguments{
\item{psid_df}{The data frame generated from psid_read() function. The user should not change anything on the data frame.}

\item{str_df}{The structure data frame generated from psid_str() function.}

\item{shape}{The shape you would like the data frame to be.
"long" if you want to have each line represent the data for each person at each year;
"wide" if you want to have each line represent the data for all waves for each person;}

\item{level}{The level of output. Default value is set to 'individual'.
The user can also set this value to 'household' if needed. Deduplication will be performed and leave only the record of household head for each household.}
}
\value{
A data frame with self-defined variable name
}
\description{
\code{psid_reshape()} serves as the final step in processing your PSID data which helps the user rename and reshape the data frame to produce output in your desired format.
}
\details{
This function offers options in data output at both the household and individual levels.
When the user specifies for household-level output, the output will only retain the household head's record for each household.
This option will be useful if the user aims to conduct family-level analysis.
In contrast, individual-level output includes details for all family members.

Additionally, \code{psid_reshape()} allows for choosing between wide and long formats.
In the wide format, variables are named as \code{VARNAME_YYYY}.
}
\examples{
# Import dataset use `psid_str()`, `psid_unzip()` and `psid_read()`
psid_varlist = c(" hh_age || [13]ER53017 [17]ER66017"," p_age || [13]ER34204")
str_df <- psid_str(varlist = psid_varlist, type = "separated")
# Below is the file path for the package test data, set this to your own directory
indir <- system.file(package = "psidread","extdata")
df <- psid_read(indir = indir,
                str_df = str_df,
                idvars = c("ER30000"),
                type = "package",
                filename = NA)
# Example 1: Individual-level output in long format
ind_long_df <- psid_reshape(psid_df = df,
                          str_df = str_df,
                          shape = "long",
                          level = "individual")
# Example 2: Household-level output in wide format
fam_wide_df <- psid_reshape(psid_df = df,
                            str_df = str_df,
                            shape = "wide",
                            level = "household")
}
