% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help_files.R
\name{qinspect}
\alias{qinspect}
\title{qinspect}
\usage{
qinspect(file)
}
\arguments{
\item{file}{the file name/path}
}
\value{
A boolean.  TRUE if the object was properly compressed.  FALSE if there is an issue.
}
\description{
Performs a quick inspection of a serialized object/file, determines whether the file was properly compressed.  
E.g., if your process was interrupted for some reason, and you suspect qsave was interrupted, you can run this function 
to test the integrity of the serialized object.
}
\examples{
x <- data.frame(int = sample(1e3, replace=TRUE), 
                 num = rnorm(1e3), 
                 char = randomStrings(1e3), stringsAsFactors = FALSE)
myfile <- tempfile()
qsave(x, myfile)
qinspect(myfile) # returns true
}
