% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ac_get_contacts.R
\name{ac_get_contacts}
\alias{ac_get_contacts}
\title{Retrieve Contacts}
\usage{
ac_get_contacts(
  ids = NULL,
  email = NULL,
  email_like = NULL,
  exclude = NULL,
  formid = NULL,
  id_greater = NULL,
  id_less = NULL,
  listid = NULL,
  search = NULL,
  segmentid = NULL,
  seriesid = NULL,
  status = NULL,
  tagid = NULL,
  created_before = NULL,
  created_after = NULL,
  updated_before = NULL,
  updated_after = NULL,
  waitid = NULL,
  in_group_lists = NULL
)
}
\arguments{
\item{ids}{Filter contacts by ID. Can be repeated for multiple IDs.}

\item{email}{Email address of the contact you want to get}

\item{email_like}{Filter contacts that contain the given value in the email address}

\item{exclude}{Exclude from the response the contact with the given ID}

\item{formid}{Filter contacts associated with the given form}

\item{id_greater}{Only include contacts with an ID greater than the given ID}

\item{id_less}{Only include contacts with an ID less than the given ID}

\item{listid}{Filter contacts associated with the given list}

\item{search}{Filter contacts that match the given value in the contact names, organization, phone or email}

\item{segmentid}{Return only contacts that match a list segment (this param initially returns segment information, when it is run a second time it will return contacts that match the segment)}

\item{seriesid}{Filter contacts associated with the given automation}

\item{status}{Filter contact by status: -1 - Any, 0 - Unconfirmed, 1 -    Active, 2 - Unsubscribed, 3 - Bounced}

\item{tagid}{Filter contacts associated with the given tag}

\item{created_before}{Filter contacts that were created prior to this date}

\item{created_after}{Filter contacts that were created after this date}

\item{updated_before}{Filter contacts that were updated before this date}

\item{updated_after}{Filter contacts that were updated after this date}

\item{waitid}{Filter by contacts in the wait queue of an automation block}

\item{in_group_lists}{Set this to TRUE in order to return only contacts that the current user has permissions to see.}
}
\value{
tibble with contacts metadata
}
\description{
Contacts are the center of activity in 'ActiveCampaign' and represent the people that the owner of an 'ActiveCampaign' account is marketing to or selling to.
}
\examples{
\dontrun{
Sys.setenv('ACTIVECAMPAGN_API_TOKEN' = "YOUR_TOKEN")
Sys.setenv('ACTIVECAMPAGN_API_URL' = "https://<your-account>.api-us1.com")

contacts <- ac_get_contacts()
}
}
\seealso{
\href{https://developers.activecampaign.com/reference#contact}{Contacts}
}
