% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sysreqs.R
\name{query_sysreqs}
\alias{query_sysreqs}
\title{Query for System Requirements}
\usage{
query_sysreqs(rang, os = "ubuntu-20.04")
}
\arguments{
\item{rang}{output from \code{\link[=resolve]{resolve()}}}

\item{os}{character, which OS to query for system requirements}
}
\value{
a \code{rang} S3 object with the following items
\item{call}{original function call}
\item{ranglets}{List of dependency graphs of all packages in \code{pkgs}}
\item{snapshot_date}{\code{snapshot_date}}
\item{no_enhances}{\code{no_enhances}}
\item{no_suggests}{\code{no_suggests}}
\item{unresolved_pkgsrefs}{Packages that can't be resolved}
\item{sysreqs}{System requirements as Linux commands}
\item{r_version}{The latest R version as of \code{snapshot_date}}
\item{os}{\code{os}}
}
\description{
This function takes an S3 object returned from \code{\link[=resolve]{resolve()}} and (re)queries the System Requirements.
}
\examples{
\donttest{
if (interactive()) {
    graph <- resolve(pkgs = c("openNLP", "LDAvis", "topicmodels", "quanteda"),
                snapshot_date = "2020-01-16", query_sysreqs = FALSE)
    graph$sysreqs
    graph2 <- query_sysreqs(graph, os = "ubuntu-20.04")
    graph2$sysreqs
}
}
}
\seealso{
\code{\link[=resolve]{resolve()}}
}
