% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{raveio-option}
\alias{raveio-option}
\alias{raveio_setopt}
\alias{raveio_resetopt}
\alias{raveio_getopt}
\alias{raveio_confpath}
\title{Set/Get 'RAVE' option}
\usage{
raveio_setopt(key, value, .save = TRUE)

raveio_resetopt(all = FALSE)

raveio_getopt(key, default = NA, temp = TRUE)

raveio_confpath(cfile = "settings.yaml")
}
\arguments{
\item{key}{character, option name}

\item{value}{character or logical of length 1, option value}

\item{.save}{whether to save to local drive, internally used to temporary
change option. Not recommended to use it directly.}

\item{all}{whether to reset all non-default keys}

\item{default}{is key not found, return default value}

\item{temp}{when saving, whether the key-value pair should be considered
temporary, a temporary settings will be ignored when saving; when getting
options, setting \code{temp} to false will reveal the actual settings.}

\item{cfile}{file name in configuration path}
}
\value{
\code{raveio_setopt} returns modified \code{value};
\code{raveio_resetopt} returns current settings as a list;
\code{raveio_confpath} returns absolute path for the settings file;
\code{raveio_getopt} returns the settings value to the given key, or
\code{default} if not found.
}
\description{
Persist settings on local configuration file
}
\details{
\code{raveio_setopt} stores key-value pair in local path.
The values are persistent and shared across multiple sessions.
There are some read-only keys such as \code{"session_string"}. Trying to
set those keys will result in error.

The following keys are reserved by 'RAVE':

\describe{
\item{\code{data_dir}}{Directory path, where processed data are stored;
default is at home directory, folder \code{~/rave_data/data_dir}}
\item{\code{raw_data_dir}}{Directory path, where raw data files are stored,
mainly the original signal files and imaging files;
default is at home directory, folder \code{~/rave_data/raw_dir}}
\item{\code{max_worker}}{Maximum number of CPU cores to use; default
is one less than the total number of CPU cores}
\item{\code{mni_template_root}}{Directory path, where 'MNI' templates
are stored}
}

\code{raveio_getopt} returns value corresponding to the keys. If key is
missing, the whole option will be returned.

If set \code{all=TRUE}, \code{raveio_resetopt} resets all keys including
non-standard ones. However \code{"session_string"} will never reset.
}
\section{Side-Effects}{

The following options will alter other packages and might cause changes in
behaviors:

\describe{
\item{\code{'disable_fork_clusters'}}{This option will change the
\code{\link{options}} \code{'dipsaus.no.fork'} and
\code{'dipsaus.cluster.backup'}, which handles the parallel computing}
\item{\code{'threeBrain_template_subject'}}{This option will set and persist
option \code{'threeBrain.template_subject'}, which changes the default
group-level template brain.}
}
}

\examples{

# get one RAVE option
ncore <- raveio_getopt("max_worker")
print(ncore)

# get all options
raveio_getopt()

# set option
raveio_setopt("disable_fork_clusters", FALSE)

}
\seealso{
\code{R_user_dir}
}
