% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shuffle_hierarchy.R
\name{shuffle_hierarchy}
\alias{shuffle_hierarchy}
\title{Shuffle multi-column hierarchy of groups}
\usage{
shuffle_hierarchy(
  data,
  group_cols,
  cols_to_shuffle = group_cols,
  leaf_has_groups = TRUE
)
}
\arguments{
\item{data}{\code{data.frame}.}

\item{group_cols}{Names of columns making up the group hierarchy.
The last column is the \emph{leaf} and is shuffled first (if also in \code{`cols_to_shuffle`}).}

\item{cols_to_shuffle}{Names of columns to shuffle hierarchically.
By default, all the \code{`group_cols`} are shuffled.}

\item{leaf_has_groups}{Whether the leaf column contains groups or values. (Logical)

When the elements are \emph{group identifiers}, they are ordered sequentially and shuffled together.

When the elements are \emph{values}, they are simply shuffled.}
}
\value{
The shuffled \code{data.frame} (\code{tibble}).
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Shuffles a tree/hierarchy of groups, one column at a time.
The levels in the last ("leaf") column are shuffled first, then the second-last column, and so on.
Elements of the same group are ordered sequentially.
}
\examples{
# Attach packages
library(rearrr)
library(dplyr)

df <- data.frame(
  'a' = rep(1:4, each = 4),
  'b' = rep(1:8, each = 2),
  'c' = 1:16
)

# Set seed for reproducibility
set.seed(2)

# Shuffle all columns
shuffle_hierarchy(df, group_cols = c('a', 'b', 'c'))

# Don't shuffle 'b' but keep grouping by it
# So 'c' will be shuffled within each group in 'b'
shuffle_hierarchy(
  data = df,
  group_cols = c('a', 'b', 'c'),
  cols_to_shuffle = c('a', 'c')
)

# Shuffle 'b' as if it's not a group column
# so elements are independent within their group
# (i.e. same-valued elements are not necessarily ordered sequentially)
shuffle_hierarchy(df, group_cols = c('a', 'b'), leaf_has_groups = FALSE)
}
\seealso{
Other rearrange functions: 
\code{\link{center_max}()},
\code{\link{center_min}()},
\code{\link{closest_to}()},
\code{\link{furthest_from}()},
\code{\link{pair_extremes}()},
\code{\link{position_max}()},
\code{\link{position_min}()},
\code{\link{rev_windows}()},
\code{\link{roll_elements}()},
\code{\link{triplet_extremes}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{rearrange functions}
