% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_sa_item.R
\name{set_spec}
\alias{set_spec}
\title{Set the specification of a SaItem}
\usage{
set_spec(sa_item, spec)
}
\arguments{
\item{sa_item}{a \code{"sa_item"} object.}

\item{spec}{the object into which the new specification is extracted/stored.}
}
\value{
a new \code{"sa_item"} with the new specification
}
\description{
Function to set the specification of a \code{"sa_item"}.
}
\examples{

library("RJDemetra")

sa_x13 <- jx13(series = ipi_c_eu[, "FR"])
sa_ts <- jtramoseats(series = ipi_c_eu[, "FR"])

wk <- new_workspace()
sap1 <- new_multiprocessing(workspace = wk, name = "sap-1")

add_sa_item(
    workspace = wk,
    multiprocessing = "sap-1",
    sa_obj = sa_x13,
    name = "tramo seats"
)

sa_item1 <- get_object(x = sap1, pos = 1L)
new_sa_item <- set_spec(sa_item = sa_item1, spec = sa_ts)

# The first sa_item is now seasonally adjusted with TRAMO-SEATS
replace_sa_item(sap = sap1, pos = 1, sa_item = new_sa_item)

}
