% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{base64dec}
\alias{base64dec}
\title{Base64 Decode}
\usage{
base64dec(x, convert = TRUE)
}
\arguments{
\item{x}{an object.}

\item{convert}{[default TRUE] logical TRUE to convert back to a character
string, FALSE to convert back to a raw vector or NA to decode and then
unserialize back to the original object.}
}
\value{
A character string, raw vector, or other object depending on the
    value of \sQuote{convert}.
}
\description{
Decodes a character string, raw vector or other object from base64 encoding.
}
\details{
The value of \sQuote{convert} should be set to TRUE, FALSE or NA to
    be the reverse of the 3 encoding operations (for strings, raw vectors and
    arbitrary objects), in order to return the original object.
}
\examples{
base64dec(base64enc("secret base"))
base64dec(base64enc(as.raw(c(1L, 2L, 4L))), convert = FALSE)
base64dec(base64enc(data.frame()), convert = NA)

}
\references{
This implementation is based that by 'The Mbed TLS Contributors'
    under the 'Mbed TLS' Trusted Firmware Project at
    \url{https://www.trustedfirmware.org/projects/mbed-tls}.
}
\seealso{
\code{\link{base64enc}}
}
