% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_functions.R
\name{predict_kinematics}
\alias{predict_kinematics}
\alias{predict_velocity_at_time}
\alias{predict_distance_at_time}
\alias{predict_acceleration_at_time}
\alias{predict_time_at_distance}
\alias{predict_velocity_at_distance}
\alias{predict_acceleration_at_distance}
\alias{predict_acceleration_at_velocity}
\title{Kinematics prediction functions}
\usage{
predict_velocity_at_time(time, MSS, TAU)

predict_distance_at_time(time, MSS, TAU)

predict_acceleration_at_time(time, MSS, TAU)

predict_time_at_distance(distance, MSS, TAU)

predict_velocity_at_distance(distance, MSS, TAU)

predict_acceleration_at_distance(distance, MSS, TAU)

predict_acceleration_at_velocity(velocity, MSS, TAU)
}
\arguments{
\item{time, distance, velocity}{Numeric vectors}

\item{MSS, TAU}{Numeric vectors. Model parameters}
}
\description{
Predicts kinematic from known \code{MSS} and \code{TAU} parameters
}
\examples{
MSS <- 8
TAU <- 0.7

time_seq <- seq(0, 6, length.out = 10)

df <- data.frame(
  time = time_seq,
  distance_at_time = predict_distance_at_time(time_seq, MSS, TAU),
  velocity_at_time = predict_velocity_at_time(time_seq, MSS, TAU),
  acceleration_at_time = predict_acceleration_at_time(time_seq, MSS, TAU)
)

df$time_at_distance <- predict_time_at_distance(df$distance_at_time, MSS, TAU)
df$velocity_at_distance <- predict_velocity_at_distance(df$distance_at_time, MSS, TAU)
df$acceleration_at_distance <- predict_acceleration_at_distance(df$distance_at_time, MSS, TAU)
df$acceleration_at_velocity <- predict_acceleration_at_velocity(df$velocity_at_time, MSS, TAU)

df
}
